import { isWebVersion, singleElementTransition, isMobile, preloader, startPreloader } from "./common.js";
import {
  API_VERSION,
  API_URL,
  HEADERS,
  NICKNAME_MIN_LENGTH,
  PASSWORD_MIN_LENGTH,
  EMAIL_REG_EXPRESSION,
  VALIDATION_MESSAGES
} from "./config.js";
import { transition, goBack, getUserData, setUserData } from "./panel.js";

var userId = undefined;

export function initAccountPage() {
  var urlParams = new URLSearchParams(window.location.search);
  var formType = urlParams.get("type");
  initForm(formType);
  goBack();
}

function initForm(formType) {
  if (formType === "login") {
    var urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get("reset")) {
      $("#login h1").after(`
      <div class="page-info">Your password has been reset.<br/>You can now use your new password to log in.</div>
    `);
    }
    initLoginBtn();
    initForgotBtn();
  } else if (formType === "sign-up") {
    $("#account-nav .login").addClass("remove-line");
    initSignUpBtn();
  } else {
    localStorage.clear();
    checkResetData();
  }
  if (["login", "sign-up"].includes(formType)) {
    singleElementTransition(`#${formType}`, true);
  }
}

function initLoginBtn() {
  $("#login").on("submit", function(e) {
    e.preventDefault();
    var email = $("#email-login").val();
    var password = $("#password-login").val();
    if (!email.match(EMAIL_REG_EXPRESSION)) {
      $("#login .invalid")
        .text(VALIDATION_MESSAGES.email)
        .removeClass("invisible");
      return;
    }
    startPreloader("#login", "#main-account");
    fetch(API_URL + "/login" + `?api_version=${API_VERSION}`, {
      method: "POST",
      headers: HEADERS,
      body: JSON.stringify({ email, password })
    })
      .then(function(response) {
        handleResponse("#login", response);
      })
      .catch(() => {
        handleError("#login");
      });
  });
}

function initForgotBtn() {
  $("#forgot").on("click", function() {
    transition("#login, #password-forgot, #confirm-password-forgot", "#login", "#forgot-section");
    initForgotSubmitBtn();
  });
}

function initSignUpBtn() {
  $("#sign-up").on("submit", function(e) {
    e.preventDefault();
    var email = $("#email-sign-up").val();
    if (!email.match(EMAIL_REG_EXPRESSION)) {
      $("#sign-up .invalid")
        .text(VALIDATION_MESSAGES.email)
        .removeClass("invisible");
      return;
    }
    startPreloader("#sign-up", "#main-account");
    fetch(API_URL + "/signup" + `?api_version=${API_VERSION}`, {
      method: "POST",
      headers: HEADERS,
      body: JSON.stringify({ email })
    })
      .then(response => {
        handleResponse("#sign-up", response);
      })
      .catch(() => {
        handleError("#sign-up");
      });
  });
}

function initCreateAccountBtn() {
  $("#sign-up-code").on("submit", function(e) {
    e.preventDefault();
    var code = $(this)
      .find("input")
      .val();
    if (!code) {
      $("#sign-up-code .invalid")
        .text(VALIDATION_MESSAGES.empty)
        .removeClass("invisible");
      return;
    }
    startPreloader("#sign-up-code", "#main-account");
    fetch(API_URL + "/code/" + userId + `?api_version=${API_VERSION}`, {
      method: "POST",
      headers: HEADERS,
      body: JSON.stringify({ code })
    })
      .then(response => {
        handleResponse("#sign-up-code", response);
      })
      .catch(() => {
        handleError("#sign-up-code");
      });
  });
}

function initCountrySelector() {
  var element = $("#country");
  element.append('<option value="" disabled selected>Select your country</option>');
  for (var key in COUNTRIES) {
    var countryName = COUNTRIES[key];
    element.append(`<option value="${key.toLowerCase()}">${countryName}</option>`);
  }
  $("#country").addClass("placeholder");
  element.on("change", function() {
    $(this).removeClass("placeholder");
  });
}

function initSubmitBtn() {
  var userData = getUserData();
  $("#email-user-details").val($("#email-sign-up").val());
  $("#user-details").on("submit", function(e) {
    e.preventDefault();
    var that = $(this);
    var nickname = that.find("#nickname").val();
    var password = that.find("#password-details").val();
    var confirmPassword = that.find("#confirm-password-details").val();
    var country = that.find("#country").val();
    if (nickname.length < NICKNAME_MIN_LENGTH) {
      $("#user-details .invalid")
        .text(VALIDATION_MESSAGES.nicknameLength)
        .removeClass("invisible");
      return;
    }
    if (password.length < PASSWORD_MIN_LENGTH || confirmPassword.length < PASSWORD_MIN_LENGTH) {
      $("#user-details .invalid")
        .text(VALIDATION_MESSAGES.passswordLength)
        .removeClass("invisible");
      return;
    }
    if (password !== confirmPassword) {
      $("#user-details .invalid")
        .text(VALIDATION_MESSAGES.passwordsMatch)
        .removeClass("invisible");
      return;
    }
    if (!country) {
      $("#user-details .invalid")
        .text(VALIDATION_MESSAGES.missingCountry)
        .removeClass("invisible");
      return;
    }
    var uniqueId = userData["userId"];
    startPreloader("#user-details", "#main-account");
    fetch(API_URL + "/edit_user/" + uniqueId + `?api_version=${API_VERSION}`, {
      method: "POST",
      headers: HEADERS,
      body: JSON.stringify({ nickname, password, country })
    })
      .then(response => {
        handleResponse("#user-details", response);
      })
      .catch(() => {
        handleError("#user-details");
      });
  });
}

function initForgotSubmitBtn() {
  $("#forgot-section").on("submit", function(e) {
    e.preventDefault();
    var that = $(this);
    var email = that.find("#email-forgot").val();
    if (!email.match(EMAIL_REG_EXPRESSION)) {
      singleElementTransition("#forgot-section .invalid", true);
      $("#forgot-section .invalid").html(VALIDATION_MESSAGES.email);
      return;
    }
    singleElementTransition("#forgot-section", false);
    setTimeout(() => {
      preloader(true, "#main-account");
    }, 300);
    fetch(API_URL + "/email" + `?api_version=${API_VERSION}`, {
      method: "POST",
      headers: HEADERS,
      body: JSON.stringify({ email })
    })
      .then(function(response) {
        response["email"] = email;
        handleResponse("#forgot-section", response);
      })
      .catch(() => {
        handleError("#forgot-section");
      });
  });
}

function checkResetData() {
  var urlParams = new URLSearchParams(window.location.search);
  var data = urlParams.get("data");
  if (!data) {
    transition("", "", "#reset, #reset-info");
    return;
  }
  startPreloader("#reset", "#main-account");
  fetch(API_URL + "/reset_check/" + data + `?api_version=${API_VERSION}`, {
    method: "POST",
    headers: HEADERS,
    body: JSON.stringify({ data })
  })
    .then(function(response) {
      handleResponse("#reset", response);
    })
    .catch(() => {
      handleError("#reset");
    });
}

function initResetPassword(email) {
  $("#email-reset").val(email);
  $("#reset").on("submit", function(e) {
    e.preventDefault();
    var that = $(this);
    var password = that.find("#password-forgot").val();
    var confirmPassword = that.find("#confirm-password-forgot").val();
    if (password.length < PASSWORD_MIN_LENGTH || confirmPassword.length < PASSWORD_MIN_LENGTH) {
      singleElementTransition("#reset .invalid", true);
      $("#reset .invalid").text(VALIDATION_MESSAGES.passswordLength);
      return;
    }
    if (password != confirmPassword) {
      singleElementTransition("#reset .invalid", true);
      $("#reset .invalid").text(VALIDATION_MESSAGES.passwordsMatch);
      return;
    }
    var urlParams = new URLSearchParams(window.location.search);
    var data = urlParams.get("data");
    var uniqueId = data.slice(0, 36);
    fetch(API_URL + "/reset/" + uniqueId + `?api_version=${API_VERSION}`, {
      method: "POST",
      headers: HEADERS,
      body: JSON.stringify({ password })
    })
      .then(function(response) {
        if (response.status >= 500) {
          throw new Error(VALIDATION_MESSAGES.serverError);
        }
        if (response && response.status === 200) {
          singleElementTransition("#reset", false);
          setTimeout(() => {
            window.location.href = "account.html?type=login&reset=1";
          }, 300);
        }
      })
      .catch(() => {
        handleError("#reset");
      });
  });
}

function handleResponse(element, response) {
  if (response.status >= 500) {
    throw new Error(VALIDATION_MESSAGES.serverError);
  }
  response.json().then(function(data) {
    setTimeout(() => {
      preloader(false, "#main-account");
      if (response && response.status == 200) {
        switch (element) {
          case "#login":
            var userDataToSet = { userId: data["unique_id"], nickname: data["nickname"] };
            var currentUserData = getUserData(["tourFinished", "tourStep"]);
            if (
              !isMobile() &&
              !isWebVersion() &&
              (!currentUserData || !currentUserData["tourFinished"] || currentUserData["tourFinished"] == "0")
            ) {
              userDataToSet["tourFinished"] = 0;
              userDataToSet["takingTour"] = 1;
            }
            if (!currentUserData || !currentUserData["tourStep"]) {
              userDataToSet["tourStep"] = "welcome";
            }
            setUserData(userDataToSet);
            userId = data["unique_id"];
            updatePaidAnalysisLeft();
            $("#expanded-menu-container #tab-logout").text(`Log out (${data["nickname"]})`);
            singleElementTransition("#account-nav", false);
            setTimeout(() => {
              $("#account-nav").empty();
              $("#main-menu-container").addClass("hide");
            }, 300);
            setTimeout(() => {
              $("#open-menu-btn-conainer").removeClass("invisible");
              $("#main-menu-container, #open-mobile-menu-btn").removeClass("hidden invisible");
              $("#header-info").removeClass("transparent");
              navigateToPage("topics.html");
            }, 600);
            setTimeout(() => {
              $("#main-menu-container").removeClass("hide");
            }, 650);
            break;
          case "#sign-up":
            transition("#sign-up", "#sign-up", "#sign-up-code");
            setUserData({ userId: data["userId"] });
            userId = data["userId"];
            initCreateAccountBtn();
            break;
          case "#sign-up-code":
            transition("#sign-up-code", "#sign-up-code", "#user-details");
            initSubmitBtn();
            initCountrySelector();
            break;
          case "#user-details":
            setUserData({ nickname: data["nickname"], tourFinished: 0, takingTour: 1 });
            window.location.href = isWebVersion() ? "import.html" : "analyse.html";
            break;
          case "#forgot-section":
            $("#reset-email").text(`${response["email"]}.`);
            transition("#forgot-section", "#forgot-section", "#forgot-info");
            break;
          case "#reset":
            transition("", "", "#reset, #password-forgot, #confirm-password-forgot, .buttons-wrapper");
            initResetPassword(data["email"]);
          default:
            break;
        }
      } else {
        handleError(element, response.status, data.detail);
      }
    }, 2000);
  });
}

function handleError(element, status = 500, message = VALIDATION_MESSAGES.serverError) {
  if (status >= 500) {
    setTimeout(() => {
      preloader(false, "#main-account");
      singleElementTransition(element, true);
      new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
    }, 2000);
  } else {
    singleElementTransition(element, true);
    if (element == "#sign-up") {
      if (status == 409) {
        $("#email-taken-info").removeClass("hidden");
        $("#sign-up .form-info").addClass("hidden");
        initForgotSubmitBtn();
        $("#reset-password-link").on("click", function() {
          $("#email-forgot").val($("#email-sign-up").val());
          transition("#sign-up", "#sign-up", "#forgot-section");
        });
      } else if (status == 404) {
        new CustomModal(VALIDATION_MESSAGES.highVolumeRequests);
      }
    } else {
      $(`${element} .invalid`)
        .text(message)
        .removeClass("invisible");
      $("#email-taken-info").addClass("hidden");
      $("#sign-up .form-info").removeClass("hidden");
    }
  }
}

$("#login, #sign-up, #sign-up-code, #user-details, #forgot-section, #reset").on("keyup", "input", function(e) {
  var error = $(this)
    .parents("form")
    .find(".invalid");
  if (!error.hasClass("invisible") && e.key !== "Enter") {
    error.addClass("invisible");
  }
});

function updatePaidAnalysisLeft() {
  fetch(API_URL + "/users/" + userId + `?api_version=${API_VERSION}`, { method: "GET", headers: HEADERS })
    .then(response => {
      if (response && response.status === 200) {
        response.json().then(data => {
          $("#token-count-span").text(data["tokens_left"]);
        });
      } else {
        $("#paid-analysis").addClass("invisible");
      }
    })
    .catch(error => {
      console.error(error);
      $("#paid-analysis").addClass("invisible");
    });
}
