import {
  API_VERSION,
  API_URL,
  ANALYSIS_STAGE,
  SYSTEM_GENERATED_CATEGORIES,
  MESSAGES,
  VALIDATION_MESSAGES
} from "./config.js";
import {
  getLastDate,
  logTabs,
  transition,
  getOnlyValidTabs,
  getUserData,
  setUserData,
  showNamingDialog,
  getDeviceName
} from "./panel.js";
import {
  getBrowser,
  singleElementTransition,
  openTabOrUrl,
  getOpenAIStatus,
  addOpenAIMessage,
  isWebVersion,
  isMobile,
  stripURL
} from "./common.js";
import { closeTabs } from "./topics.js";
import { TourMessageManager } from "./tour.js";

var allTabs = [];
var alreadyAnalysedTabs = [];
window.interval = undefined;
window.progressInterval = undefined;
window.isAnalyseInit = undefined;
var userId = undefined;
var isFailed = false;
var openAIStatus = false;
var breakdownNames = [];

export async function initAnalysePage() {
  $("#search-tab-field").attr("placeholder", "Search tabs");
  var userData = getUserData();
  userId = userData["userId"];
  isAnalyseInit = true;
  if (userData["breakdownNames"]) {
    breakdownNames = JSON.parse(userData["breakdownNames"]);
  }
  var tabsObject = getBrowser(true);
  if (tabsObject) {
    tabsObject.query({}, function(tabs) {
      allTabs = getOnlyValidTabs(tabs);
      checkProgress();
      initTabsListButtons();
    });
  } else {
    checkProgress();
    $("#view-tabs-list").remove();
  }
  openAIStatus = await getOpenAIStatus();
  initUnanalysedListButtons();
  $("#bubble-info-holder").on("mouseover", function() {
    $("#graphic-container").toggleClass("hovered");
  });
  $("#bubble-info-holder").on("mouseout", function() {
    $("#graphic-container").toggleClass("hovered");
  });
  $("main").tooltip();
  TourMessageManager.initByPage();
}

function checkProgress() {
  progressInterval = setInterval(() => {
    updateAnalysisProgress(progressInterval, allTabs);
  }, 10000);
  if (isAnalyseInit) {
    updateAnalysisProgress(progressInterval, allTabs);
  }
}

function initTabsListButtons() {
  $("#view-tabs-list").on("click", function() {
    $("#tabs-list li").removeClass("hidden");
    transition("#analyse-container", "#analyse-container", "#tab-list-container");
    if ($("#tour-modal").length) {
      CustomModal.closeModal("#tour-modal .modal-content-holder");
    }
  });
  $("#cancel-btn").on("click", function() {
    transition("#tab-list-container", "#tab-list-container", "#analyse-container");
    if (getUserData("takingTour") == "1" && getUserData("tourStep") == "run") {
      TourMessageManager.updateMessage("run");
    }
  });
}

function initTabsList(analysedTabsIds, openedTabs) {
  $("#tabs-list").empty();
  $("#tabs-list").append(`
    <div id="match-none" class="hidden">
      No matching tabs found.
    </div>
  `);
  var newTabs = [];
  var oldTabs = [];
  for (var tabData of openedTabs) {
    if (oldTabs.filter(tab => tab.url == tabData.url).length || newTabs.filter(tab => tab.url == tabData.url).length) {
      continue;
    }
    if (analysedTabsIds.indexOf(stripURL(tabData.url)) > -1) {
      oldTabs.push(tabData);
    } else {
      newTabs.push(tabData);
    }
  }

  addTabsRows(newTabs, "New tabs");
  addTabsRows(oldTabs, "Previously analysed tabs");
  initTabListSearch(newTabs, oldTabs);
  if (newTabs.length && oldTabs.length) {
    $("#old-tab-group").css("margin-top", "40px");
  }

  $("#tabs-list .close-btn").each(function() {
    $(this).on("click", function() {
      $(this)
        .closest("li")
        .addClass("removed");
      if (!$(".new-tab:not(.removed):not(.hidden)").length) {
        $("#new-tab-group").addClass("hidden");
      } else if (!$(".old-tab:not(.removed):not(.hidden)").length) {
        $("#old-tab-group").addClass("hidden");
      }
    });
  });

  $("#tabs-list a").each(function() {
    $(this).on("click", function(e) {
      e.preventDefault();
      e.stopPropagation();
      var linkElement = $(this);
      var tabId = linkElement.attr("data-id");
      openTabOrUrl(!tabId.match(/.*[a-zA-Z]+.*/) ? parseInt(tabId) : 0, linkElement.attr("href"));
    });
  });

  function addTabsRows(tabs, groupName) {
    if (!tabs.length) {
      return;
    }
    var type = groupName == "New tabs" ? "new-tab" : "old-tab";
    if (groupName == "New tabs") {
      $("#tabs-list").append(
        `<p class='text-black'>Below are the new tabs you have opened since your last analysis. Once you click “Run analysis” these tabs will be analysed, summarised, and categorised into tab groups. You can remove any tabs from the list below that you do not wish to be analysed by TabCrunch.</p>`
      );
    }
    $("#tabs-list").append(`<li id="${type}-group" class="list-group">${groupName}:</li>`);
    for (var tabData of tabs) {
      var domain = tabData.url.indexOf("://") > -1 ? tabData.url.split("/")[2] : tabData.url.split("/")[0];
      domain = domain.replace(/https?:\/\//, "");
      $("#tabs-list").append(`
        <li class="${type}" data-id="${tabData.id}">
            <button class="close-btn icon-btn" data-title="Remove tab from analysis"></button>
            <a href="${tabData.url}" target="__blank" data-id="${tabData.id}">${domain} - ${tabData.title}</a>
        </li>
      `);
    }
  }
}

function initRunButton(newTabs) {
  if (isWebVersion()) {
    window.location.href = "import.html?p=import";
    return;
  }
  if (!newTabs.length) {
    new CustomModal(VALIDATION_MESSAGES.noNewTabs);
    return;
  }
  if ($(this).attr("id") == "run-from-list-btn") {
    var removedTabs = Object.values($("#tabs-list .new-tab.removed a, #tabs-list .old-tab.removed a")).map(
      removedRow => {
        return $(removedRow).attr("href");
      }
    );
    allTabs = allTabs.filter(tabData => {
      return removedTabs.indexOf(tabData.url) == -1;
    });
  }
  var tabsForAnalysis = allTabs.reduce((acc, tab) => {
    if (acc.filter(tabData => tabData.url == tab.url).length == 0) {
      acc.push(tab);
    }
    return acc;
  }, []);
  if (getDeviceName()) {
    initMinTabsMessage(startAnalysis, tabsForAnalysis);
  } else if (!isWebVersion()) {
    showNamingDialog(startAnalysis, tabsForAnalysis);
  }

  if ($("#tour-modal").length) {
    CustomModal.closeModal("#tour-modal .modal-content-holder");
  }
  if (getUserData("takingTour") == "1" && getUserData("tourStep") == "run") {
    TourMessageManager.updateStep("closeTabs");
  }

  function startAnalysis(tabs) {
    transition(
      "#analyse-container, #tab-list-container, #welcome-message",
      "#analyse-container, #tab-list-container, #welcome-message",
      ""
    );
    logTabs(tabs, userId, () => {
      isAnalyseInit = true;
      if ($(this).attr("id") == "run-from-list-btn") {
        transition("#tab-list-container", "#tab-list-container", "#analyse-container");
      }
      checkProgress();
    });
  }
}

export function initMinTabsMessage(callback, tabs) {
  tabs = tabs.filter(tab => !alreadyAnalysedTabs.some(analysedTab => tab.url === analysedTab.url));
  if (tabs.concat(alreadyAnalysedTabs).length >= 20) {
    callback(tabs);
  } else {
    new CustomModal(
      `Please note that tab grouping works best with at least 20 tabs.`,
      "",
      `<button class="cancel border-btn">Cancel</button>
      <button class="continue gradient-btn">Run analysis anyway</button>`
    );
    $("#custom-modal .continue").click(function() {
      $("#custom-modal #close-modal-icon").click();
      setTimeout(() => {
        callback(tabs);
      }, 350);
    });
    $("#custom-modal .cancel").click(function() {
      $("#custom-modal #close-modal-icon").click();
    });
  }
}

function initNoActiveAnalysis(analysedTabsCount, allTabsCount) {
  var userData = getUserData();
  if (userData["lastAnalysisDate"]) {
    var date = getLastDate([], false, userData["lastAnalysisDate"]);
    $("#analysed-on").text(date.formatted);
    $("#analyse-info-text").text(` tabs ${analysedTabsCount > 0 ? "last" : ""} analysed on `);
  } else {
    $("#analysed-tabs-count").text("");
    $("#analyse-info-text").text("No tabs have been analysed yet.");
  }
  if (userId && userData["nickname"] && analysedTabsCount) {
    if (analysedTabsCount <= allTabsCount) {
      $("#view-topics").removeClass("hidden");
    } else {
      $("#view-tabs-list").addClass("hidden");
      $("#run-btn span").text("See last analysis");
      $("#run-btn")
        .off("click")
        .removeAttr("target href");
      $("#run-btn").on("click", function() {
        if ($("#main-analyse").length) {
          navigateToPage("topics.html");
        } else {
          $("#view-topics")[0].click();
        }
      });
    }
  }
  var elementToShow = analysedTabsCount < allTabsCount ? ", #view-tabs-list" : "";
  transition("#analyse-progress", "#analyse-progress", `#analyse-reults, #run-btn, #links-container ${elementToShow}`);
}

function initActiveAnalysis() {
  $(".bubble").addClass("animation");
  singleElementTransition("#analyse-container", true);
  var elementsToHide = $("#links-container").length ? "#links-container" : "#view-tabs-list";
  $(`#analyse-reults, #bubble-info-holder, #links-container, #run-btn, ${elementsToHide}`).addClass("invisible");
  setTimeout(() => {
    $("#analyse-reults, #run-btn").addClass("hidden");
    $("#analyse-progress").removeClass("hidden");
  }, 300);
  setTimeout(() => {
    $("#analyse-progress").removeClass("invisible");
  }, 1000);
}

export function updateGraph(analysedTabsCount, allTabsCount, pageType = "page") {
  var analysedPercentage = 0;
  if (allTabsCount) {
    analysedPercentage = parseInt((analysedTabsCount * 100) / allTabsCount);
  }
  if (analysedTabsCount > allTabsCount) {
    analysedPercentage = 100;
    analysedTabsCount = allTabsCount;
  }
  if (pageType == "page") {
    $("#bubbles-container").height(`calc(${analysedPercentage}%)`);
    var position = parseInt(($(".waves").height() * analysedPercentage) / 100);
    var waveHeight = position > 77 ? 250 - position - 190 : 100 - position;
    $("#wave-back").css({ transform: `translateY(${waveHeight}px) scale(1.5)` });
    $("#wave-front").css({ transform: `translateY(${waveHeight}px) scale(1.5)` });
  } else {
    $("#bubbles-container").height(`calc(${analysedPercentage}%)`);
    var position = parseInt(($(".waves").height() * analysedPercentage) / 100);
    var waveHeight = position > 86 ? 140 - position - 70 : 86 - position;
    $("#wave-back").css({ transform: `translateY(${waveHeight}px) scale(0.75, 0.56)` });
    $("#wave-front").css({ transform: `translateY(${waveHeight}px) scale(0.75, 0.56)` });
  }
  if (!analysedPercentage || breakdownNames.length) {
    $("#bubble-info-holder").addClass("inner-glow");
  } else {
    $("#bubble-info-holder").removeClass("inner-glow");
  }
}

function initUnanalysedListButtons() {
  $("#view-unanalysed").on("click", function() {
    CustomModal.closeModal("#tour-text-container");
    transition("#analyse-container", "#analyse-container", "#unanalysed-list-container");
  });
  $("#unanalysed-back-btn").on("click", function() {
    TourMessageManager.initByStep(["closeTabs", "closeTabsFromGroups"], "closeTabs");
    transition("#unanalysed-list-container", "#unanalysed-list-container", "#analyse-container");
  });
  $("#unanalysed-view-topics-btn").on("click", function() {
    navigateToPage("topics.html");
  });
}

function initUnanalysedList(unanalysedTabs) {
  $("#unanalysed-list").empty();
  for (var tabData of unanalysedTabs) {
    var domain = tabData.url.indexOf("://") > -1 ? tabData.url.split("/")[2] : tabData.url.split("/")[0];
    domain = domain.replace(/https?:\/\//, "");
    $("#unanalysed-list").append(`
        <li>
            <a href="${tabData.url}" target="__blank" data-id="${tabData.id}">${domain} - ${tabData.title}</a>
        </li>
    `);
  }
  var browserObject = getBrowser(true, true);
  $("#unanalysed-list a").each(function(e) {
    $(this).on("click", function() {
      var tabId = parseInt($(this).attr("data-id"));
      try {
        browserObject.update(tabId, { active: true }, function() {
          e.preventDefault();
        });
      } catch (_error) {}
    });
  });
}

function initTabListSearch(newTabs, oldTabs) {
  $("#search-tab-field").on("keyup", function() {
    $("#tabs-list li").addClass("hidden");
    var search = $(this)
      .val()
      .toLowerCase();
    $("#clear-search-btn").toggleClass("invisible", !search);
    if (!search) {
      $("#tabs-list li").removeClass("hidden");
      return;
    }
    var matchingNewTabs = newTabs.filter(tab => filterTabs(tab, search));
    var matchingOldTabs = oldTabs.filter(tab => filterTabs(tab, search));
    var searchNewTabs = searchTabs(matchingNewTabs, "new");
    var searchOldTabs = searchTabs(matchingOldTabs, "old");
    if (!searchNewTabs && !searchOldTabs) {
      $(`#match-none`).removeClass("hidden");
    } else {
      $(`#match-none`).addClass("hidden");
    }

    $("#clear-search-btn").on("click", function() {
      var inputElement = $(this)
        .parents(".search-container")
        .find("input");
      inputElement.val("");
      $(`#match-none`).addClass("hidden");
      $("#tabs-list li").removeClass("hidden");
      $("#clear-search-btn").addClass("invisible");
    });

    function searchTabs(tabs, type) {
      var hasMathces = false;
      for (var tab of tabs) {
        var element = $(`#tabs-list [data-id=${tab.id}]`);
        if (element.length && !element.hasClass("removed")) {
          hasMathces = true;
        }
        $(`#tabs-list [data-id=${tab.id}]`).removeClass("hidden");
      }
      var tabGroupElement = $(type == "new" ? "#new-tab-group" : "#old-tab-group");
      if (hasMathces) {
        tabGroupElement.removeClass("hidden");
      } else {
        tabGroupElement.addClass("hidden");
      }
      return hasMathces;
    }
  });

  function filterTabs(tab, search) {
    return (tab.title && tab.title.toLowerCase().indexOf(search) > -1) || (tab.url && tab.url.indexOf(search) > -1);
  }
}

export function updateAnalysisProgress(progressInterval, openedTabs, pageType = "page") {
  var userData = getUserData();
  if (userData && userData.userId) {
    userId = userData.userId;
  }
  if (!userId) {
    $("#bubble-info-holder").addClass("inner-glow");
    return;
  }
  fetch(API_URL + "/progress/" + userId + `?api_version=${API_VERSION}`, { method: "GET" })
    .then(response => response.json())
    .then(data => {
      if (data.status === "failed" && $("#bubbles-container .bubble").hasClass("animation")) {
        isFailed = true;
      }
      if (data.status === "rate_limit_reached" && pageType == "page") {
        clearInterval(progressInterval);
        new CustomModal(
          "<div class='failed-analysis'>You have reached TabCrunch's rate limit. Please try again later.</div>",
          "",
          `<button class="btn">OK</button>`
        );
        $("#custom-modal .btn").click(function() {
          navigateToPage("topics.html");
          $("#custom-modal #close-modal-icon").click();
        });
      }
      if (data.status === "rate_limit_reached" && pageType == "popup") {
        data.status = "no-analysis";
      }
      alreadyAnalysedTabs = data && data.urls ? data.urls : [];
      var analysedTabs = data && data.urls ? data.urls.filter(tab => tab.reason != "Failed to analyze") : [];
      var isActiveAnalysis = true;
      var browserType = getBrowser();
      var analysedTabsIds = analysedTabs.map(tabData => {
        return stripURL(tabData.url);
      });
      var newTabs = openedTabs.reduce((acc, tab) => {
        if (
          analysedTabsIds.indexOf(stripURL(tab.url)) == -1 &&
          acc.filter(tabData => tabData.url == tab.url).length == 0
        ) {
          acc.push(tab);
        }
        return acc;
      }, []);
      var allTabsCount = analysedTabs.length + newTabs.length;
      if (!data.status || data.status === "failed") {
        data.status = "no-analysis";
      }
      if (analysedTabs.length) {
        var date = getLastDate(analysedTabs, true);
        if (date) {
          setUserData({
            lastAnalysisDate: date.raw
          });
        }
      }
      var isInit = (pageType == "page" && isAnalyseInit) || (pageType == "popup" && isPopupInit);
      if (data.status != $("#analyse-status").attr("data-status")) {
        if (data.status == "completed" || data.status == "no-analysis") {
          $("#analyse-status").removeClass("bigger-font");
          clearInterval(progressInterval);
          if (["major", "critical"].includes(openAIStatus)) {
            addOpenAIMessage(openAIStatus, "#analyse-container");
          }
          if (breakdownNames.length) {
            addBreakdownMessage();
          }
          if (!["major", "critical"].includes(openAIStatus) && !breakdownNames.length) {
            $("#run-btn, #run-from-list-btn").on("click", () => {
              initRunButton(newTabs);
            });
          }
          if (isInit) {
            $(".page-title").removeClass("invisible");
            var getParams = new URLSearchParams(window.location.search);
            if (getParams.get("list") && getBrowser(true)) {
              $("#analyse-container").addClass("hidden invisible");
              $("#view-tabs-list").click();
            } else if (getParams.get("started")) {
              initRunButton(newTabs);
            }
          }
          isActiveAnalysis = false;
          $("#new-tabs-count").text(newTabs.length);
          if (isWebVersion()) {
            var extentionTypeText = isMobile() ? "TabCrunch mobile" : "TabCrunch";
            var analyseText =
              browserType == "safari"
                ? `To run analysis, open the ${extentionTypeText} extension.`
                : 'To run analysis, <span class="text-link page-link" data-href="import.html?p=import">import your mobile tabs</span> or use the desktop extension.';
            $("#new-tabs-text").html(analyseText);
          }
          if (isInit) {
            updateGraphicAfterProgressChange(analysedTabs.length, allTabsCount, isActiveAnalysis, pageType);
          } else {
            if (isFailed) {
              clearInterval(progressInterval);
              new CustomModal(
                "<div class='failed-analysis'>Oops, something went wrong. Please run the analysis again.</div>",
                "",
                `<button class="border-btn btn">OK</button>`
              );
              $("#custom-modal .btn").click(function() {
                $("#custom-modal #close-modal-icon").click();
              });
            }
            var unanalysedTabs = data.urls.filter(tabData => {
              return tabData.cluster_name == SYSTEM_GENERATED_CATEGORIES.missingPage;
            });
            updateGraphicOnCompletion(data.status, analysedTabs, analysedTabs, unanalysedTabs, pageType);
          }
        } else {
          var statusData = ANALYSIS_STAGE[data.status];
          singleElementTransition("#analyse-status", false);
          $(".page-title").addClass("invisible");
          setTimeout(() => {
            $("#analyse-status").text(statusData.text);
            $("#analyse-status").addClass("bigger-font");
            $("#analyse-status").attr("data-status", data.status);
          }, 300);
          setTimeout(() => {
            singleElementTransition("#analyse-status", true);
          }, 350);
          if (isInit) {
            updateGraphicAfterProgressChange(statusData.percentage, 100, isActiveAnalysis, pageType);
          } else {
            updateGraph(statusData.percentage, 100, pageType);
          }
        }
      }

      if (isInit) {
        initTabsList(analysedTabsIds, openedTabs);
        if (pageType == "popup") {
          isPopupInit = false;
        } else {
          isAnalyseInit = false;
        }
        if (!analysedTabs.length) {
          $("#bubble-info-holder").addClass("inner-glow");
        }
      }
      if (pageType == "popup") {
        $("#analyse-wrapper").removeClass("invisible");
      } else {
        if (!$("#menu-move").hasClass("expanded")) {
          $("#main-analyse").removeClass("transparent");
        }
      }
    })
    .catch(error => {
      console.error("Error:", error);
    });
}

function updateGraphicOnCompletion(status, analysedTabs, allTabsCount, unanalysedTabs, pageType = "page") {
  $(".bubble").removeClass("animation");
  var additionalElemetToHide = unanalysedTabs.length ? "" : ", #unanalysed-tabs-text";
  var additionalElemetToShow = unanalysedTabs.length ? ", #unanalysed-tabs-text" : "";
  $("#unanalysed-info-text").text(unanalysedTabs.length > 1 ? " tabs were not analysed. " : " tab was not analysed. ");
  initUnanalysedList(unanalysedTabs);
  if (pageType == "page") {
    $("#view-topics").on("click", function() {
      navigateToPage("topics.html");
    });
  }
  transition(
    `#analyse-info-holder, #view-tabs-list, #analyse-progress, #new-tabs-text ${additionalElemetToHide}`,
    `#analyse-progress, #new-tabs-text ${additionalElemetToHide}`,
    `#analyse-info-holder, #analyse-reults, #bubble-info-holder ${additionalElemetToShow}`
  );
  if (status == "completed") {
    $("#run-btn, #run-from-list-btn").off("click");
    $("#run-btn").on("click", function() {
      if (getUserData("takingTour") == "1" && getUserData("tourStep") == "closeTabs") {
        TourMessageManager.updateStep("groups");
      }
      navigateToPage("topics.html");
    });
  }
  setTimeout(() => {
    $("#unanalysed-tabs-count").text(unanalysedTabs.length);
    $("#analysed-tabs-count, #analysed-on").text("");
    $("#analyse-status").attr("data-status", status);
    if (status == "completed") {
      $("#run-btn span").text("See analysis");
      $(".page-title").removeClass("invisible");
      if (userId.includes("temp")) {
        $("#tab-analyse")
          .parents(".menu-option")
          .addClass("temp-user")
          .find(".lock-menu")
          .removeClass("hidden invisible");
      }
      $("#analyse-container .page-title").text(ANALYSIS_STAGE[status].text);
      updateGraph(ANALYSIS_STAGE[status].percentage, 100, pageType);
      $("#analyse-info-text").text(
        `${analysedTabs.length - unanalysedTabs.length}/ ${analysedTabs.length} tabs analysed.`
      );
      singleElementTransition("#run-btn", true);
      singleElementTransition("#close-tabs-text-button", true);
      if (!$(".popup-wrapper").length) {
        TourMessageManager.initByStep(["closeTabs"], "closeTabs");
      }
      $("#close-tabs-text-button").on("click", function() {
        closeTabs(analysedTabs);
      });
    } else {
      singleElementTransition("#run-btn", false);
      $("#analyse-info-text").text(ANALYSIS_STAGE[status].text);
    }
  }, 300);
  $("#analysed-tabs-count").text(allTabsCount);
}

function updateGraphicAfterProgressChange(analysedTabs, allTabsCount, isActiveAnalysis, pageType) {
  $("#analysed-tabs-count").text(analysedTabs);
  if (pageType == "popup") {
    $("#analyse-reults").removeClass("hidden");
    setTimeout(() => {
      isActiveAnalysis ? initActiveAnalysis() : initNoActiveAnalysis(analysedTabs, allTabsCount);
      updateGraph(analysedTabs, allTabsCount, pageType);
    }, 450);
  } else {
    isActiveAnalysis ? initActiveAnalysis() : initNoActiveAnalysis(analysedTabs, allTabsCount);
    updateGraph(analysedTabs, allTabsCount, pageType);
  }
}

function addBreakdownMessage() {
  $("#analyse-container").append(
    `<div class="breakdown-message transition invisible hidden"><div>${MESSAGES.breakdownInfo}</div></div>`
  );
  $(".waves").remove();
  $("#bubble-info-holder").addClass("bubble-no-click");
  $("#bubble-info-holder").addClass("inner-glow");
  singleElementTransition(".breakdown-message", true);
}
