import { API_VERSION, API_URL, HEADERS } from "./config.js";
import { getBrowser } from "./common.js";

var browserObject = getBrowser(true, false);

try {
  async function sendPageContent(tabs, uniqueId, deviceName) {
    var tabList = [];
    var browserType = getBrowser();
    if (!browserType) {
      browserType = "extension";
    }
    for (var tab of tabs) {
      fetch(API_URL + "/tab_collection_status/" + uniqueId + `?api_version=${API_VERSION}`, {
        method: "GET",
        headers: HEADERS
      }).catch(err => {
        console.error(err);
      });
      try {
        if (tab.discarded != undefined) {
          if (tab.discarded == true) {
            await (typeof browser === "undefined" ? chrome : browser).tabs.reload(tab["id"], { bypassCache: true });
          }
          var result = await (typeof browser === "undefined" ? chrome : browser).scripting.executeScript({
            target: { tabId: tab.id },
            func: DOMtoString
          });
          tabList.push({
            tabTitle: typeof tab.title == "string" ? tab.title : "",
            tabId: tab.id.toString(),
            tabUrl: typeof tab.url == "string" ? tab.url : "",
            tabContent: typeof result[0].result == "string" ? result[0].result : "",
            tabSource: deviceName ? deviceName : "Computer"
          });
        } else {
          tabList.push({
            tabTitle: typeof tab.title == "string" ? tab.title : "",
            tabId: tab.id.toString(),
            tabUrl: typeof tab.url == "string" ? tab.url : "",
            tabContent: "",
            tabSource: deviceName ? deviceName : "Computer"
          });
        }
      } catch (error) {
        console.log(error);
        tabList.push({
          tabTitle: typeof tab.title == "string" ? tab.title : "",
          tabId: tab.id.toString(),
          tabUrl: typeof tab.url == "string" ? tab.url : "",
          tabContent: "",
          tabSource: deviceName ? deviceName : "Computer"
        });
      }
    }
    fetch(API_URL + "/tabs/" + uniqueId + `?api_version=${API_VERSION}`, {
      method: "POST",
      headers: HEADERS,
      body: JSON.stringify(tabList)
    }).catch(err => {
      console.error(err);
    });
  }

  browserObject.runtime.onMessage.addListener(function(request, _sender, sendResponse) {
    if (request.type == "getTabsContent") {
      sendPageContent(request.tabs, request.uniqueId, request.deviceName);
      sendResponse({});
    }
    return true;
  });
} catch (error) {
  // TODO add error handling
}

function DOMtoString() {
  return window.top.document.body.innerText
    .toLowerCase()
    .replaceAll(".", ". ")
    .replaceAll("\n", " ");
}
