import { inlineLiveSearchFormEvent, getUserData } from "./panel.js";
import { getBrowser } from "./common.js";

var liveTable = undefined;
var linksData = [];
var userData = {};
var tableColumns = ["title", "website", "dateClosed", "dateAdded"];
var columnsRenamed = {
  website: "Websites",
  title: "Tabs",
  dateAdded: "Date added",
  dateClosed: "Date closed"
};

export function initClosedTabsPage() {
  linksData = [];
  userData = getUserData();
  initPage();
}

async function initPage() {
  $("#closed-tabs-main").removeClass("transparent");
  await initTableData();
  initTable();
  $("#liveTable table").removeClass("transparent");
  $("#search-tab-field").attr("placeholder", "Search closed tabs");
  $("#search-tabs").on("keyup", function() {
    inlineLiveSearchFormEvent(this, false);
  });
  $("#clear-search-btn").on("click", function() {
    var inputElement = $(this)
      .parents(".search-container")
      .find("input");
    inputElement.val("");
    inlineLiveSearchFormEvent(inputElement[0], true);
    $("#clear-search-btn").addClass("invisible");
  });
}

function getUnanalysedClosedTabs() {
  var browserObject = getBrowser(true, false);
  if (browserObject && browserObject.storage) {
    return browserObject.storage.local.get("closedTabs").then(closedTabs => {
      closedTabs = closedTabs.closedTabs
        ? Object.values(closedTabs.closedTabs).filter(tabData => {
            return tabData.url && tabData.url.indexOf("http") > -1;
          })
        : [];
      closedTabs.map(tabData => {
        tabData.createdDate = getFormattedDate(tabData.createdDate);
        tabData.closedDate = getFormattedDate(tabData.closedDate);
      });
      return closedTabs;
    });
  }
}

function getFormattedDate(datetime) {
  var date = "";
  if (datetime) {
    datetime = new Date(datetime);
    for (var dateSegment of [datetime.getDate(), datetime.getMonth() + 1]) {
      date += (dateSegment < 10 ? `0${dateSegment}` : dateSegment) + ".";
    }
    date += datetime.getFullYear();
  }
  return date;
}

async function initTableData() {
  var i = 1;
  var tabsData = await getUnanalysedClosedTabs();
  for (var tab of tabsData) {
    var domain = tab.url.indexOf("://") > -1 ? tab.url.split("/")[2] : tab.url.split("/")[0];
    domain = domain.replace(/https?:\/\//, "");
    var rowData = {
      "#": i++,
      website: initRowCell(domain, "website"),
      title: initRowCell(tab.title, "title", tab),
      dateClosed: initRowCell(tab.closedDate, "dateClosed"),
      dateAdded: initRowCell(tab.createdDate ? tab.createdDate : "", "dateAdded")
    };
    linksData.push(rowData);
  }
}

function initTable() {
  var columns = initColumns(tableColumns);
  var tableData = linksData;
  if (!tableData || !tableData.length) {
    $("#no-tabs").removeClass("hidden");
    return;
  }
  $("#closed-tabs-info").removeClass("hidden");
  liveTable = new LiveTable(".live-table", tableData, {
    columns: columns,
    sorting: "website",
    noData: "No matching closed tabs."
  });
}

function initRowCell(value, column, data = []) {
  if (column == "dateAdded" || column == "dateClosed") {
    var dateFragments = value.split("-");
    if (dateFragments.length > 1) {
      dateFragments[2] = dateFragments[2].split("T")[0];
      var dateFormated = dateFragments[2].split("T")[0] + "." + dateFragments[1] + "." + dateFragments[0];
    } else if (value.indexOf(".") > -1) {
      var dateFormated = value;
    } else {
      var dateFormated = "";
    }
    return {
      value: value,
      searchValue: dateFormated,
      text: dateFormated
    };
  } else if (column == "title") {
    return {
      value: value,
      text: `<a class="link" target="_blank" href="${data.url}">${data.title ? data.title : data.url}</a>`
    };
  } else {
    return {
      value: value,
      text: value
    };
  }
}

function initColumns(columnNames) {
  var result = [];
  for (var column of columnNames) {
    result.push({
      name: column,
      text: columnsRenamed[column] ? columnsRenamed[column] : column
    });
  }
  return result;
}
