export const API_URL = "https://tabcrunch.com/aitabs";
export const SITE_URL = "https://tabcrunch.com/portable";
export const API_VERSION = "1.0.0";
export const HEADERS = {
  "Content-Type": "application/json"
};

export const MESSAGES = {
  breakdownGroup:
    "This tab group is currently being broken down into smaller groups. This may take a few minutes. Breakdown in progress…",
  breakdownInfo: "Breakdown in progress. This may take a few minutes. Please try again later."
};

export const VALIDATION_MESSAGES = {
  empty: "Required field.",
  nicknameLength: "Nickname must contain at least 3 symbols!",
  passswordLength: "Password/Confirm password must contain at least 6 symbols!",
  singlePassswordLength: "Password must contain at least 6 symbols!",
  passwordsMatch: "Passwords do not match.",
  email: "Please provide a valid email address.",
  emailExists: "<span>This email is already registered. <a href='account.html?type=login'>Try logging in.</a></span>",
  emailNotFound: "<span>Email not found. Let's get you <a href='account.html?type=sign-up'>signed up.</a></span>",
  importSuccess: "Your tabs were imported successfully.",
  serverError: "An error occurred. Please try again or contact our team.<br>Thank you.",
  fileExtension: "Please upload a valid file type.",
  maxTabsLimit:
    "The selected tabs for analysis exceeds the maximum allowed amount of %%MAX_TABS%% for your account. Upgrade your account or remove tabs from the list.",
  bookmarksPermissionDenied: "In order to add tabs to your bookmarks, please grant TabCrunch access to your bookmars.",
  bookmarkNotSupported: "Your browser does not support this feature. Please use the browser's bookmarking options.",
  tabBarGroupPermissionDenied:
    "In order to group the tabs in Chrome's tab bar, please grant TabCrunch access to your tab bar groups.",
  notificationsPermissionDenied:
    "In order to add reminders to your tabs, please grant TabCrunch access to your notifications.",
  noLogs: "There is no log data for your tabs yet.",
  highVolumeRequests: "We're sorry! Due to a high volume of requests, this action cannot be performed at this time.",
  closeGroupError: "Some tabs could not be closed in your browser or have already been closed.",
  missingCountry: "Please select your country",
  noNewTabs: "No new tabs to analyse."
};

export const POPUP_MESSAGES = {
  tabsOpen: "Tabs successfully opened.",
  tabMove: '%%TABS_OR_TAB%% successfully moved to "%%GROUP%%".',
  tabMoveError: "Error with moving tab to new group.",
  tabClose: "%%TABS_OR_TAB%% successfully closed.",
  groupClose: "Group successfully closed.",
  tabCloseNotFound: "Tab/s already closed in browser.",
  tabCloseError: "Error with closing tab/s.",
  tabOpenError: "Error with opening the tab.",
  tabsAlreadyOpen: "Tabs are already opened in your browser.",
  tabBookmark: 'Tab successfully added to bookmark folder "%%GROUP%%".',
  groupBookmark: 'Tabs successfully added to bookmark folder "%%GROUP%%".',
  tabBookmarkError: "Error with bookmarking tab.",
  groupBookmarkError: "Error with bookmarking tabs.",
  reminder: "Reminder successfully created.",
  reminderError: "Error with creating reminder.",
  reminderDateError: "Error with reminder date.",
  reminderSnoozeError: "Error with snoozing reminder.",
  titleEdit: "Group name successfully changed.",
  titleEditError: "Error with group name change.",
  shareLink: "Link copied to clipboard.",
  shareLinkError: "Error with copying the share link.",
  importError: "The provided URLs are invalid.",
  noCategoriesSelected: "Please select at least one group.",
  settingUpdate: "Setting successfully updated.",
  loginDataUpdate: "Login data successfully updated.",
  clearTabs: "Current tab groups and tab-related data cleared successfully.",
  deleteAccount: "Your request has been sent successfully.",
  openAIMinor: "We are experiencing a partial system outage at the moment which may cause minor delays or issues.",
  openAIMajor:
    "We are experiencing a service outage at the moment, and are not able to perform analysis.<br/> Please try again later.",
  tabFavouriteRemove: "Tab successfully removed from favourite tabs.",
  tabFavourite: "Tab successfully added to favourite tabs.",
  tabFavouriteError: "Error with adding to favourite tabs.",
  achievementsError: "Error with loading achievements."
};

export const PREVIOUS_POPUP_SECTION = {
  login: "auth-info",
  "sign-up": "auth-info",
  "sign-up-code": "sign-up",
  "user-details": "auth-info",
  "forgot-section": "login"
};

export const ANALYSIS_STAGE = {
  scraping_and_parsing: {
    percentage: 30,
    text: "Collecting tabs content..."
  },
  summary: {
    percentage: 45,
    text: "Generating summaries..."
  },
  clustering: {
    percentage: 65,
    text: "Grouping tabs..."
  },
  group_summary: {
    percentage: 80,
    text: "Summarising groups..."
  },
  completed: {
    percentage: 100,
    text: "Analysis completed!"
  }
};

export const NICKNAME_MIN_LENGTH = 3;

export const PASSWORD_MIN_LENGTH = 6;

export const URL_REG_EXPRESSION = /https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{1,256}\.[a-zA-Z0-9()]{1,6}\b([-a-zA-Z0-9()@:%_\+.~#?&\/=]*)/gm;

export const EMAIL_REG_EXPRESSION = /^[^<>\s]+@([a-zA-Z0-9_-]+\.){0,}[a-zA-Z0-9_-]+\.\w{2,}$/gm;

export const KEY_CODES = {
  escape: 27,
  enter: 13
};

export const SYSTEM_GENERATED_CATEGORIES = {
  engine: "Search engine results",
  service: "Web mail service",
  missingPage: "Unanalysed",
  socialNetwork: "Social networking",
  ecommerce: "Ecommerce Online Stores",
  other: "Other"
};

export const DOWNLOAD_LINKS = {
  chrome: "https://chromewebstore.google.com/detail/tabcrunch/akhifcioibiofmbpfpkfagkklldlmkgn",
  firefox: "https://addons.mozilla.org/firefox/addon/tabcrunch/",
  safari: "https://apps.apple.com/us/app/tabcrunch/id6476495158"
};

export const ACHIEVEMENT_TYPES = {
  groups: "of tab groups<br>closed",
  tabs: "of tabs<br>closed",
  summary: "of summaries<br>read",
  readingTime: "of total reading time<br>completed"
};
