import { VALIDATION_MESSAGES } from "./config.js";
import { transition } from "./panel.js";

function successHandler(data) {
  try {
    const dataParsed = JSON.parse(data);
    if (dataParsed.status && dataParsed.status === "1") {
      $("#contacts-main form")[0].reset();
      transition("form", "form", "#thank-you-message-container");
      return; // Stop the execution here, show OK popup to the user
    }
  } catch (e) {
    console.log(e);
  }
  new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
}

function errorHandler() {
  new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
}

export function initContacts() {
  var ajaxUrl = "https://tabcrunch.com/contacts-ajax.html";
  var contactUsForm = $("#contacts-main form");
  contactUsForm.on("submit", function(e) {
    e.preventDefault();
    e.stopPropagation();
    var data = {};
    for (var field of ["name", "email", "subject", "message"]) {
      data[field] = contactUsForm.find(`[name=${field}]`).val();
    }
    $.ajax({
      method: "POST",
      url: ajaxUrl,
      data,
      success: successHandler,
      error: errorHandler
    });
  });
  setTimeout(() => {
    $("#contacts-main").removeClass("transparent");
  }, 300);
}
