import { getBrowser } from "./common.js";
import { transition } from "./panel.js";

window.CustomModal = class CustomModal {
  constructor(markup, title = "", footer = "", parameters = {}) {
    this.markup = markup;
    this.title = title;
    this.footer = footer;
    this.width = 500;
    this.lazyClose = true;
    this.customId = "";
    for (var key in parameters) {
      this[key] = parameters[key];
    }

    var mainMarkup = `<div id="custom-modal" class="custom-modal ${
      this.additionalClasses ? this.additionalClasses : ""
    }">
                <div class="modal-background ${this.hideBackground ? "hidden" : ""}"></div>
                <div class="modal-content-holder">
                    <div class="modal-content-box ${this.fullHeight ? "full-height" : ""}">
                        <div class="modal-main-content"></div>
                        <div class="close-modal">
                            <button id="close-modal-icon" class="close-btn icon-btn"></button>
                        </div>
                    </div>
                </div>
            </div>`;
    if (!this.modalContainer) {
      this.modalContainer = "body";
    }
    $(this.modalContainer).append(mainMarkup);

    var closeCallback = this.closeCallback ? this.closeCallback : null;
    if (!this.disableDefaultClose) {
      $(".custom-modal #close-modal-icon").on("click", function() {
        CustomModal.closeModal($(this), closeCallback);
      });
    }
    if (this.customId !== "") {
      $(".custom-modal").attr("id", this.customId);
    }

    if (this.lazyClose == true && !this.disableDefaultClose) {
      $(".modal-background").on("click", function() {
        CustomModal.closeModal($(this), closeCallback);
      });
    }

    this.populateModal();
    this.modalFadeIn();
    if (this.footer === "history") {
      $(".modal-main-footer .btn").on("click", function() {
        CustomModal.openTabsBtn();
      });
    }
  }

  populateModal() {
    if (this.title != "") {
      $(".modal-content-box:last").prepend(`<div class="modal-main-title">` + this.title + `</div>`);
    }
    $(".modal-main-content:last").append(this.markup);
    if (this.footer === "default") {
      $(".modal-content-box:last").append(
        `<div class="modal-main-footer"><button type="button" class="btn close-modal-btn" onclick="CustomModal.closeModal(this);"><span>Close</span></button></div>`
      );
    } else if (this.footer === "delete") {
      $(".modal-content-box:last").append(
        `<div class="modal-main-footer delete-modal"><button class="cancel border-btn">Cancel</button><button class="delete gradient-btn">Delete</button></div>`
      );
    } else if (this.footer === "history") {
      $(".modal-content-box:last").append(
        `<div class="modal-main-footer"><button class="history border-btn btn">Open all tabs in browser</button></div>`
      );
    } else if (this.footer) {
      $(".modal-content-box:last").append(`<div class="modal-main-footer">` + this.footer + `</div>`);
    }
  }

  modalFadeIn() {
    var that = this;
    setTimeout(function() {
      $(that.modalContainer)
        .find(".custom-modal")
        .addClass("modal-fade");
    }, 25);
    setTimeout(function() {
      $(that.modalContainer)
        .find(".modal-content-holder")
        .addClass("fade-in-animation");
    }, 250);
  }

  static closeModal(elem, callback) {
    $(".tour-highlight").removeClass("tour-highlight");
    if (!elem) {
      elem = $(".custom-modal #close-modal-icon");
    }
    var modal = $(elem).parents(".custom-modal");
    var modalContentHolder = $(elem).parents(".modal-content-holder");
    if ($(elem).hasClass("modal-background")) {
      modalContentHolder = $(elem).siblings(".modal-content-holder");
    }

    modalContentHolder.removeClass("fade-in-animation");
    modal.removeClass("modal-fade");
    setTimeout(function() {
      modal.remove();
    }, 500);
    if (callback) {
      setTimeout(() => {
        callback();
      }, 750);
    }

    var isFailedAnalysisModal = modal.find(".failed-analysis");
    var isDuplicateTabsModal = modal.find(".run-without-closing").length;
    var isDuplicateTabsButton = $(elem).hasClass("duplicate-btn");
    if (isFailedAnalysisModal.length || (isDuplicateTabsModal && !isDuplicateTabsButton)) {
      if (window.location.href.indexOf("started=1") == -1) {
        window.location.reload();
      } else {
        window.location.href = window.location.href.replace("started=1", "");
      }
    }
  }

  static openTabsBtn() {
    var urls = $("#full-tab-list .url");
    function openTabs(urls) {
      CustomModal.closeModal();
      transition("#action-type-container, #history-tabs", "", "#preloader-message");
      var tabsObject = getBrowser(true);
      if (tabsObject) {
        tabsObject.query({}, function(openedTabs) {
          var openedUrls = openedTabs.map(tab => tab.url);
          var urlsToOpen = [];
          urls.each(function() {
            var url = $(this)
              .find("a")
              .attr("href");
            if (url && openedUrls.indexOf(url) == -1) {
              urlsToOpen.push(url);
            }
          });
          var tabOpener = tabsGenerator(urlsToOpen);
          var tabInterval = setInterval(() => {
            if (tabOpener.next().done) {
              clearInterval(tabInterval);
              transition("#preloader-message", "#preloader-message", "#action-type-container, #history-tabs");
            }
          }, 200);
        });
      }
      setTimeout(() => {
        $(".custom-modal #close-modal-icon").click();
      }, 300);
    }

    function* tabsGenerator(urls) {
      var tabsObject = getBrowser(true);
      for (var url of urls) {
        yield tabsObject.create({ url, active: false });
      }
    }

    if (urls.length > 30) {
      $(".modal-main-footer")
        .empty()
        .append(
          `<div class="history-footer">
            <div class="history-title">You are about to open over 30 tabs in your browser. This may cause your device to run slower. Are you sure you wish to open all tabs in your browser?</div>
            <div class="buttons-wrapper">
            <button class="confirm btn border-btn">Yes, open tabs in browser</button>
            <button class="cancel btn gradient-btn">Cancel</button>
            </div>
          </div>`
        );
      $(".modal-main-footer .cancel").on("click", function() {
        $(".custom-modal #close-modal-icon").click();
      });
      $(".modal-main-footer .confirm").on("click", function() {
        openTabs(urls);
      });
    } else {
      openTabs(urls);
    }
  }
};
