import { API_VERSION, API_URL, HEADERS, VALIDATION_MESSAGES } from "./config.js";
import { getUserData, inlineLiveSearchFormEvent } from "./panel.js";
import { escapeHTML, addPopupMessage, openTabOrUrl } from "./common.js";

var uniqueId = undefined;
var userData = {};
var favouriteData = [];
var columns = [];
var columnsRenamed = {
  title: "Tabs",
  favouriteTime: "Date added",
  summary: "Summary",
  x: "Remove"
};
var liveTable = undefined;
var tabsData = [];

var callback = function() {
  fetch(API_URL + "/favourite/" + uniqueId + `?api_version=${API_VERSION}`, { method: "GET" })
    .then(response => {
      if (!response.ok) {
        throw new Error(VALIDATION_MESSAGES.serverError);
      }
      return response.json();
    })
    .then(data => {
      if (data["urls"]) {
        tabsData = data["urls"];
        initTableData();
        initTable();
      }
      setTimeout(() => {
        $("#favourite-main").removeClass("transparent");
      }, 200);
    })
    .catch(error => {
      new CustomModal(error.message, "", "");
    });
};

export function initFavouritePage() {
  favouriteData = [];
  userData = getUserData();
  uniqueId = userData["userId"];
  callback();
  $("main").tooltip();
  columns = initColumns(["x", "#", "title", "summary", "favouriteTime"]);
  $("#search-tab-field").on("keyup", function() {
    inlineLiveSearchFormEvent(this, false);
  });
  $("#clear-search-btn").on("click", function() {
    var inputElement = $(this)
      .parents(".search-container")
      .find("input");
    inputElement.val("");
    inlineLiveSearchFormEvent(inputElement[0], true);
    $("#clear-search-btn").addClass("invisible");
  });
}

function initTableData() {
  var i = 1;
  for (var tab of tabsData) {
    var domain = tab.url.indexOf("://") > -1 ? tab.url.split("/")[2] : tab.url.split("/")[0];
    domain = domain.replace(/https?:\/\//, "");
    var rowData = {
      tabId: initRowCell(tab.tabId, "tabId", tab),
      "#": i++,
      x: initRowCell("", "x", tab),
      summary: initRowCell(tab.hasSummary, "summary", tab),
      title: initRowCell(escapeHTML(tab.title), "title", tab),
      favouriteTime: initRowCell(tab.favouriteTime ? tab.favouriteTime : "", "favouriteTime")
    };
    favouriteData.push(rowData);
  }
}

function initRowCell(value, column, data = []) {
  if (!value && value !== 0) {
    value = "";
  }
  if (column == "favouriteTime") {
    var dateFragments = value.split("-");
    var dateFormated = "";
    if (dateFragments.length > 1) {
      dateFragments[2] = dateFragments[2].split("T")[0];
      dateFormated = dateFragments[2].split("T")[0] + "." + dateFragments[1] + "." + dateFragments[0];
    }
    return {
      value: value,
      searchValue: dateFormated,
      text: dateFormated,
      class: column
    };
  } else if (column == "x") {
    return {
      value: value,
      text: value,
      __onClick: initRemoveTabBtn
    };
  } else if (column == "title") {
    if (!value.trim()) {
      value = data.url.replace(/https?:\/\//, "");
    }
    var text = value && value.length > 90 ? value.slice(0, 90) + "..." : value;

    return {
      value: value,
      text: `<a class="link title" target="_blank" href="${data.url}" data-tab-id="${data.tabId}" data-title="Visit page">${text}</a>`,
      __onClick: initTabOpen
    };
  } else if (column == "summary") {
    return {
      value: value,
      text: `<a class="link page-link" href="tab.html?id=${data.tabId}&t=${data.groupId}&redirect=1">View summary</a`
    };
  } else {
    return {
      value: value,
      text: value,
      class: column
    };
  }
}

function initTabOpen(pageLink, e) {
  e.preventDefault();
  e.stopPropagation();
  var linkElement = $(pageLink).find(".link");
  var tabId = linkElement.attr("data-tab-id");
  openTabOrUrl(!tabId.match(/.*[a-zA-Z]+.*/) ? parseInt(tabId) : 0, linkElement.attr("href"));
}

function initColumns(columnNames) {
  var result = [];
  for (var column of columnNames) {
    var columnData = {
      name: column,
      text: columnsRenamed[column] ? columnsRenamed[column] : column,
      default: "asc"
    };
    if (column == "x") {
      columnData["title"] = "Remove from favourite tabs";
    }
    result.push(columnData);
  }
  return result;
}

function initTable() {
  var orderBy =
    userData["tabsSortField"] &&
    columns.filter(columnData => {
      return columnData.name == userData["tabsSortField"];
    }).length
      ? userData["tabsSortField"]
      : "favouriteTime";
  liveTable = new LiveTable(".live-table", favouriteData, {
    columns: columns,
    sorting: orderBy,
    order: "desc",
    noSorting: ["x"],
    instance: "favourite"
  });
}

function initRemoveTabBtn(removeBtn, _event) {
  var element = $(removeBtn).closest("tr");
  var tabId = element.find(".title").attr("data-tab-id");
  fetch(API_URL + "/favourite/" + uniqueId + `?api_version=${API_VERSION}`, {
    method: "POST",
    headers: HEADERS,
    body: JSON.stringify({ tabId })
  })
    .then(response => {
      if (response.status >= 500) {
        throw new Error(VALIDATION_MESSAGES.serverError);
      }
      if (response.ok) {
        addPopupMessage("tabFavouriteRemove");
      }
    })
    .catch(error => {
      new CustomModal(error.message, "", "");
    });
  updateTableData(tabId);
}

function updateTableData(tabToRemove) {
  favouriteData = [];
  var newTabsData = [];
  for (var tab of tabsData) {
    if (tabToRemove.indexOf(tab.tabId) === -1) {
      newTabsData.push(tab);
    }
  }
  tabsData = newTabsData;
  initTableData();
  initTable();
}
