import { API_VERSION, API_URL, VALIDATION_MESSAGES, HEADERS } from "./config.js";
import { getUserData } from "./panel.js";
import { singleElementTransition, isMobile, escapeHTML, isWebVersion, escapeSpecialCharacters } from "./common.js";
import { TourMessageManager } from "./tour.js";

var uniqueId = undefined;
var userData = {};
var comparisonData = undefined;
var sort = false;
var pageType = "tree";

var callback = function() {
  fetch(API_URL + "/history_file/" + uniqueId + `?api_version=${API_VERSION}`, { method: "GET" })
    .then(response => {
      if (!response.ok) {
        throw new Error(VALIDATION_MESSAGES.serverError);
      }
      return response.json();
    })
    .then(data => {
      comparisonData = prepareHistoryData(data.data);
      initListButton();
      initComparisonButton();
      $(pageType == "list" ? "#list" : "#timeline").click();
      $("main").removeClass("invisible");
      setTimeout(() => {
        TourMessageManager.initByPage();
      }, 300);
    })
    .catch(error => {
      new CustomModal(error.message, "", "");
    });
};

export function initHistoryPage() {
  userData = getUserData();
  uniqueId = userData["userId"];
  callback();
  sortListAnalysis();
  search();
  $("main").tooltip();
}

function initListButton() {
  $("#list").on("click", function() {
    pageType = "list";
    $("#timeline").removeClass("title");
    $("#list").addClass("title");
    singleElementTransition(".scroll-container", false);
    $("#search-tab-field").val("");

    setTimeout(() => {
      $("main").addClass("main-centered");
      $("#history-tabs").empty();
      var tabsContainer = $("#history-list #tabs-list");
      tabsContainer.empty();
      var timestamps = !sort ? Object.keys(comparisonData) : Object.keys(comparisonData).reverse();
      var counter = !sort ? timestamps.length - 1 : 0;
      for (const key of timestamps) {
        var tabsCount = comparisonData[key]["all"].length;
        var analysisRowHTML = `<p class="analysis"><span class="title">Analysis ${counter +
          1}: </span><span class="tabs-count see-urls" data-timestamp="${key}" data-type="all">${tabsCount} ${
          tabsCount > 1 ? "tabs" : "tab"
        }</span> analysed on ${key}`;
        analysisRowHTML += "</p>";
        for (const tab of comparisonData[key]["all"]) {
          var linkText = tab.title ? escapeSpecialCharacters(tab.title) : tab.URL.replace(/https?:\/\//, "");
          analysisRowHTML += `<div class="search-entity url hidden invisible"><a href="${escapeSpecialCharacters(
            tab.URL
          )}" class="tab-url" data-href="${escapeSpecialCharacters(tab.URL)}" target="_blank">${linkText}</a></div>`;
        }
        tabsContainer.append(analysisRowHTML);
        !sort ? counter-- : counter++;
      }
      seeFullList();
      singleElementTransition("#history-list", true);
    }, 300);
  });
}

function initComparisonButton() {
  $("#timeline").on("click", function() {
    pageType = "tree";
    singleElementTransition("#history-list", false);
    $("#timeline").addClass("title");
    $("#list").removeClass("title");
    setTimeout(() => {
      $("main").removeClass("main-centered");
      $("#history-list #tabs-list").empty();
      $("#history-tabs").empty();
      sort = false;
      renderComparisonData(comparisonData);
      singleElementTransition(".scroll-container", true);
    }, 300);
  });
}

function initCloseBtn() {
  $("#full-tab-list .close-btn").on("click", function() {
    var url = $(this)
      .parent()
      .find("a")
      .attr("href");
    fetch(API_URL + "/force_delete_history/" + uniqueId + `?api_version=${API_VERSION}`, {
      method: "POST",
      headers: HEADERS,
      body: JSON.stringify({ url })
    })
      .then(response => {
        if (response.ok) {
          if ($("#full-tab-list .close-btn").length <= 1) {
            CustomModal.closeModal();
          } else {
            $(`div.url a[href="${url}"]`)
              .closest("div.url")
              .remove();
          }
          initHistoryPage();
        }
      })
      .catch(() => {
        new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
      });
  });
}

function renderComparisonData(comparisonData) {
  var timestamps = Object.keys(comparisonData).reverse();
  var counter = timestamps.length - 1;
  for (const key in comparisonData) {
    var analysisRowHTML = "<div class='flow-row'>";
    var analysis = comparisonData[key];
    analysisRowHTML +=
      isMobile() && window.innerWidth < 768
        ? ""
        : getAdditionDeletionTemplate(analysis.deletions, "deletions", timestamps[counter]);
    var source = "";
    if (counter == 0) {
      source = analysis.all[0].source;
    } else {
      if (analysis.additions[0]?.source) {
        source = analysis.additions[0].source;
      } else if (analysis.deletions[0]?.source) {
        source = analysis.deletions[0].source;
      }
    }
    analysisRowHTML += getAnalysisTemplate(
      analysis.all.length,
      timestamps[counter],
      counter + 1,
      analysis.additions.length,
      analysis.deletions.length,
      source
    );
    analysisRowHTML +=
      isMobile() && window.innerWidth < 768
        ? ""
        : getAdditionDeletionTemplate(analysis.additions, "additions", timestamps[counter]);
    analysisRowHTML += "</div>";
    if (!$(".vertical-dots").length) {
      $("#history-tabs").append(`<div class="vertical-dots"></div>`);
    }
    $("#history-tabs").append(analysisRowHTML);
    counter--;
  }
  seeFullList();
  if (!isMobile() && window.innerWidth > 768) {
    $(".fill-container").on("mouseover", function() {
      $(this)
        .parents(".graphic-container")
        .toggleClass("hovered");
    });
    $(".fill-container").on("mouseout", function() {
      $(this)
        .parents(".graphic-container")
        .toggleClass("hovered");
    });
  }
}

function getAdditionDeletionTemplate(tabs, type, timestamp) {
  var containerClass = type === "additions" ? "right" : "left";
  if (tabs.length == 0) {
    var resultHMTL = `<div class="side-node ${containerClass}-node invisible"></div>`;
    if (type === "deletions") {
      return `${resultHMTL}<div class="flow-dot invisible"></div><div class="dotted-line invisible"></div>`;
    } else {
      return `<div class="dotted-line invisible"></div><div class="flow-dot invisible"></div>${resultHMTL}`;
    }
  }
  var urls = "";
  var count = 0;
  for (const tab of tabs) {
    if (count < 3) {
      var linkText = tab.title ? tab.title : tab.URL.replace(/https?:\/\//, "");
      urls += `<div class="url"><a href="${escapeSpecialCharacters(tab.URL)}" target="_blank">${escapeHTML(
        linkText
      )}</a></div>`;
    }
    count++;
  }
  var otherTabsCount = tabs.length - 3;
  var footer =
    tabs.length > 3
      ? `<div>... and ${otherTabsCount} other ${
          otherTabsCount > 1 ? "tabs" : "tab"
        }.</div><div class="see-urls see-all" data-timestamp="${timestamp}" data-type="${type}"><img src="images/list.svg" class="url-icon">See full list</div>`
      : "";
  var resultHMTL = `<div class="side-node ${containerClass}-node">
    <div class="title">${tabs.length} ${type === "additions" ? "new" : "closed"} ${
    tabs.length > 1 ? "tabs" : "tab"
  }:</div>
    ${urls}
    ${footer}
  </div>`;
  if (type === "deletions") {
    return `${resultHMTL}<div class="flow-dot"></div><div class="dotted-line"></div>`;
  } else {
    return `<div class="dotted-line"></div><div class="flow-dot"></div>${resultHMTL}`;
  }
}

function getAnalysisTemplate(tabsLength, timestamp, index, newTabsLength, closedTabsLength, source) {
  var dataTitle = "data-title='See analysed tabs'";
  var seeAllClass = "see-all";
  if (isMobile() && window.innerWidth < 768) {
    dataTitle = "";
    seeAllClass = "see-urls";
  }
  source = source === "manual" ? "imported" : source;
  source = source.charAt(0).toUpperCase() + source.slice(1);
  var html = `<div class="graphic-container">
  <div class="outline">
       <div class="fill-container" ${dataTitle} data-timestamp="${timestamp}" data-type="all">
          <div class="title">Analysis ${index}</div>
                <div class="tab-source">${source}</div>
                <div class="timestamp">${
                  timestamp.includes("at") ? timestamp.replace(" at ", " ") : timestamp.replace(/,([^,]*)$/, " $1")
                }</div>
                <div class="${seeAllClass}" data-timestamp="${timestamp}" data-type="all">${tabsLength} ${
    tabsLength > 1 ? "tabs" : "tab"
  }</div>`;

  if (isMobile() && window.innerWidth < 768) {
    if (newTabsLength > 0) {
      html += `<div class="see-urls" data-timestamp="${timestamp}" data-type="additions">${newTabsLength} new ${
        newTabsLength > 1 ? "tabs" : "tab"
      }</div>`;
    }
    if (closedTabsLength > 0) {
      html += `<div class="see-urls" data-timestamp="${timestamp}" data-type="deletions">${closedTabsLength} closed ${
        closedTabsLength > 1 ? "tabs" : "tab"
      }</div>`;
    }
  }
  html += `</div></div></div>`;
  return html;
}

function seeFullList() {
  $(".see-urls, .fill-container").on("click", function() {
    if (isMobile() && window.innerWidth < 768 && $(this).hasClass("fill-container")) {
      return;
    }
    var title = "Analysed";
    var timestamp = $(this).attr("data-timestamp");
    var type = $(this).attr("data-type");
    if (type === "additions") {
      title = "New";
    } else if (type === "deletions") {
      title = "Closed";
    }
    var data = comparisonData[timestamp][type];
    var html = "<div id='full-tab-list'>";
    html += `<h3 class="history-tab-title">${title} tabs</h3>`;
    html += `<div class="urls-list">`;
    for (const tabData of data) {
      html += `<div class="url"><button class="close-btn icon-btn history-btn"></button><a href="${escapeSpecialCharacters(
        tabData["URL"]
      )}" target="_blank">${escapeHTML(
        tabData["title"] ? tabData["title"] : tabData["URL"].replace(/https?:\/\//, "")
      )}</a></div>`;
    }
    html += "</div></div>";
    var footer = isWebVersion() ? "" : "history";
    $("#tour-modal").remove();
    if ($("#tour-modal").length) {
      setTimeout(() => {
        new CustomModal(html, "", footer, {
          customId: "full-page-modal",
          closeCallback: TourMessageManager.initByPage
        });
        initCloseBtn();
      }, 250);
    } else {
      new CustomModal(html, "", footer, { customId: "full-page-modal", closeCallback: TourMessageManager.initByPage });
      initCloseBtn();
    }
  });
}

function sortListAnalysis() {
  $(".sort-control").on("click", function() {
    sort = !sort;
    $("#list").click();
  });
}

function search() {
  $("#search-tab-field").on("keyup", function() {
    var input = $(this)
      .val()
      .toLowerCase();
    $(".search-entity").addClass("hidden invisible");
    $("#clear-search-btn").toggleClass("invisible", !input);
    if (!input) {
      return;
    }
    $(".tab-url").each(function(index, tab) {
      var href = $(tab).attr("href");
      var title = $(tab).text();
      if (href.toLowerCase().includes(input) || title.toLowerCase().includes(input)) {
        singleElementTransition($(tab).parent(), true);
      }
    });
  });
  $("#clear-search-btn").on("click", function() {
    var inputElement = $(this)
      .parents(".search-container")
      .find("input");
    inputElement.val("");
    $(".search-entity").addClass("hidden invisible");
    $("#clear-search-btn").addClass("invisible");
  });
}

function prepareHistoryData(data) {
  var historyData = {};
  for (var timestamp of Object.keys(data).reverse()) {
    historyData[timestamp] = data[timestamp];
  }
  var result = [];
  var previousTimestamp = undefined;
  for (var analysisDate in historyData) {
    var dateFormatted = new Intl.DateTimeFormat("en-US", {
      dateStyle: "medium",
      timeStyle: "short",
      hour12: false
    }).format(new Date(analysisDate * 1000));
    result[dateFormatted] = { additions: [], all: [], deletions: [] };
    var additions = Object.values(historyData[analysisDate]["additions"]);
    var deletions = Object.values(historyData[analysisDate]["deletions"]);
    if (!previousTimestamp) {
      result[dateFormatted]["all"] = additions;
      additions = [];
    } else {
      var previousAnalysisAll = [...result[previousTimestamp]["all"], ...additions];
      var closedTabsUrls = deletions.map(deletion => deletion.URL);
      previousAnalysisAll = previousAnalysisAll.filter(function(element) {
        return !closedTabsUrls.includes(element.URL);
      });
      result[dateFormatted]["all"] = Object.values(previousAnalysisAll);
    }
    previousTimestamp = dateFormatted;
    result[dateFormatted]["additions"] = additions;
    result[dateFormatted]["deletions"] = deletions;
  }
  var toReturn = [];
  for (var timestamp of Object.keys(result).reverse()) {
    toReturn[timestamp] = result[timestamp];
  }
  return toReturn;
}
