import { isMobile, singleElementTransition } from "./common.js";
import { getUserData } from "./panel.js";
import { SITE_URL } from "./config.js";
import { TourMessageManager } from "./tour.js";

export class InstructionsModal {
  constructor(type) {
    this.type = type;
    this.selectedBrowser = "";
    this.filenamePrefix = "";
    this.instructionsStep = 0;

    if (type == "import") {
      this.instructionsData = mobileImportInstructions;
    } else if (type == "close") {
      this.instructionsData = closeTabsInstuction;
    }
    this.initContainer();
  }

  initContainer() {
    CustomModal.closeModal();
    fetch("include/instructions.html")
      .then(response => response.text())
      .then(data => {
        $("body").prepend(data);
        singleElementTransition("#modal-background", true);
        singleElementTransition("#modal-container", true);

        this.initBrowserSelector();
        this.initStepButtons();
        this.initCloseButton();
        $("#app-store-link").on("click", function() {
          window.open("https://apps.apple.com/app/tabcrunch/id6476495158", "_blank");
        });

        if (this.type == "import") {
          var userData = getUserData();
          new QRCode($("#qrcode")[0], {
            text: `${SITE_URL}/validation.html?id=${userData["userId"]}`,
            width: 128,
            height: 128
          });
        }
      });
  }

  initCloseButton() {
    $("#modal-close-btn").on("click", () => {
      $("#modal-background").addClass("invisible");
      $("#modal-container").addClass("invisible");
      this.instructionsStep = 0;
      setTimeout(() => {
        $("#modal-background").remove();
        $("#modal-container").remove();
        TourMessageManager.initByPage();
      }, 400);
    });
  }

  initBrowserSelector() {
    var that = this;
    $("#browser-container .icon-btn").on("click", function() {
      that.selectedBrowser = $(this).attr("data-browser");
      that.filenamePrefix = `${that.type}-${that.selectedBrowser}`;

      $("#browser-container").addClass("invisible");
      $("#modal-buttons svg").removeClass("invisible");
      $("#modal-buttons .right-arrow-btn").trigger("click");
    });
  }

  initStepButtons() {
    var that = this;
    $("#modal-buttons .left-arrow-btn, #modal-buttons .right-arrow-btn").on("click", function() {
      var button = $(this);
      var buttonType = button.attr("data-direction");
      var stepModifier = buttonType == "left" ? -1 : 1;
      var stepData = that.instructionsData[that.selectedBrowser];

      if (
        (stepModifier == 1 && that.instructionsStep > stepData.texts.length - 1) ||
        (stepModifier == -1 && !that.instructionsStep)
      ) {
        return;
      }

      // Prevent clicking before the button's transition ends
      if (button.hasClass("loading")) {
        return;
      }
      button.addClass("loading");

      that.instructionsStep += stepModifier;

      if (that.instructionsStep == stepData.texts.length - 1) {
        $("#modal-buttons .right-arrow-btn").addClass("invisible");
      }

      $("#modal-title, #modal-text, #qr-container").addClass("invisible");
      $("#instruction-img").addClass("invisible-img");
      if (!that.instructionsStep) {
        $("#modal-buttons svg").addClass("invisible");
      }

      setTimeout(() => {
        var imagePosition = !isMobile()
          ? stepData.positions[that.instructionsStep]
          : stepData.positionsMobile[that.instructionsStep];
        var imageId = stepData.imageIds[that.instructionsStep];

        if (!that.instructionsStep) {
          $("#instruction-img").addClass("hidden");
          $("#browser-container").removeClass("hidden");
        } else {
          $("#browser-container").addClass("hidden");
        }

        $("#modal-title").text(`Step ${that.instructionsStep + 1}`);
        $("#modal-text").html(stepData.texts[that.instructionsStep]);

        if (imageId) {
          $("#instruction-img").attr("src", `images/instructions/${that.filenamePrefix}-${imageId}.png`);
          $("#instruction-img").css({ transform: `translateX(${imagePosition})` });
          $("#instruction-img").removeClass("hidden");
          $("#instruction-img").on("load", showElements);
        } else {
          $("#instruction-img").addClass("hidden");
          showElements();
        }

        if (that.type == "import" && that.instructionsStep == 1) {
          singleElementTransition("#qr-container", true);
          if (that.selectedBrowser == "chrome") {
            $("#app-store-link").addClass("hidden");
            $("#qrcode").removeClass("hidden");
          } else {
            $("#qrcode").addClass("hidden");
            $("#app-store-link").removeClass("hidden");
          }
        } else {
          $("#qr-container").addClass("hidden");
        }
      }, 400);

      setTimeout(() => {
        if (!that.instructionsStep) {
          $("#browser-container").removeClass("invisible");
        }
      }, 600);
    });

    function showElements() {
      $("#instruction-img").removeClass("invisible-img");
      $("#modal-title, #modal-text").removeClass("invisible");
      $("#modal-title, #modal-text").removeClass("invisible");
      if (
        that.instructionsStep &&
        that.instructionsStep < that.instructionsData[that.selectedBrowser].texts.length - 1
      ) {
        $("#modal-buttons .right-arrow-btn").removeClass("invisible");
      }
      $(".loading").removeClass("loading");
    }
  }
}

var closeTabsInstuction = {
  chrome: {
    texts: [
      "Select your mobile browser<br/>to get the correct instructions:",
      "Tap the tabs icon.",
      "Press the menu button in the top right corner.",
      "Select Close all tabs.",
      "Confirm if you wish to close all tabs."
    ],
    positions: [0, "16%", "18%", "19%", "18%"],
    positionsMobile: [0, "16%", "20%", "18%", "18%"],
    imageIds: [null, 1, 2, 3, 4]
  },
  safari: {
    texts: [
      "Select your mobile browser<br/>to get the correct instructions:",
      "To close all tabs at the same time,<br>tap the Tabs icon on the bottom right.",
      "Touch and hold Done.",
      "Then tap Close All Tabs."
    ],
    positions: [0, "16%", "18%", "18%"],
    positionsMobile: [0, "16%", "18%", "18%"],
    imageIds: [null, 1, 2, 3]
  }
};

var mobileImportInstructions = {
  chrome: {
    texts: [
      "Select your mobile browser<br/>to get the correct instructions:",
      "Scan the QR code to open your account on your mobile device.",
      "Open the tabs menu by clicking the icon in the right corner of the browser toolbar.",
      "Open the tab options menu by clicking the three vertical dots in the right corner of the tabs page.",
      'Click on the "Select tabs" option from the dropdown menu.',
      "Open the tab options menu again.",
      'Click on the "Select all" option from the dropdown menu.',
      'Click on the "Share tabs" option from the dropdown menu.',
      'Click the "Copy" button.',
      'Paste the link here, close the tabs you don\'t wish to categorise, and click "Analyse tabs".'
    ],
    positions: [0, 0, "36px", "42px", "38px", "42px", "32px", "38px", "-30px", "0px"],
    positionsMobile: [0, 0, "17%", "18%", "17%", "19%", "16%", "18%", "-15%", 0],
    imageIds: [null, null, 1, 2, 3, 4, 5, 6, 7, 8]
  },
  safari: {
    texts: [
      "Select your mobile browser<br/>to get the correct instructions:",
      "Download TabCrunch on the App Store...Or you can import your mobile tabs manually by following this tutorial.",
      "Select the tabs icon in the bottom right corner to open the tabs menu in Safari.",
      "Press and hold the tabs button at the bottom.",
      "Click on “Copy links”.",
      "Paste the link here, close the tabs you don't wish to categorise, and click “Analyse tabs”."
    ],
    positions: [0, 0, "38px", "22px", "36px", 0],
    positionsMobile: [0, 0, "17%", "11%", "17%", 0],
    imageIds: [null, null, 1, 2, 3, 4]
  }
};
