import { API_VERSION, API_URL, HEADERS, PREVIOUS_POPUP_SECTION, VALIDATION_MESSAGES, KEY_CODES } from "./config.js";
import { initTopicsPage } from "./topics.js";
import { initTopicPage } from "./topic.js";
import { initTabPage } from "./tab.js";
import { initAnalysePage } from "./analyse.js";
import { initImportPage } from "./import.js";
import { initSearchPage } from "./search.js";
import { initClosedTabsPage } from "./closed-tabs.js";
import { initSettingsPage } from "./settings.js";
import { initAccountPage } from "./account.js";
import { initStatisticsPage } from "./statistics.js";
import { initIndexPage } from "./validation.js";
import { initHistoryPage } from "./history.js";
import { initFavouritePage } from "./favourite.js";
import {
  isMobile,
  getBrowser,
  timeout,
  isWebVersion,
  singleElementTransition,
  addCustomOrderedList,
  preloader
} from "./common.js";
import { initContacts } from "./contacts.js";
import { TourMessageManager } from "./tour.js";
import { initSharePage } from "./share.js";
import { initMinTabsMessage } from "./analyse.js";

var userData = {};
var userId = undefined;
var nickname = undefined;
var tokensLeft = undefined;
window.tempUserCluster = null;
window.tempUserTrial = true;

checkUserAccessToPage(window.location.pathname);

$(document).on("click", ".page-link", async function(e) {
  e.preventDefault();
  if (
    $(this)
      .parents(".menu-option")
      .hasClass("temp-user")
  ) {
    showRegisterMessage();
    return;
  }
  $("#menu-options-container .menu-option span").removeClass("page-link");
  userData = getUserData();
  if ($(this).attr("data-href") && !$("#expanded-menu-container").hasClass("hidden")) {
    triggerMenuAnimation(null, $(this).attr("data-href"), false);
  }
  var response = await fetch(API_URL + "/users/" + userData["userId"] + `?api_version=${API_VERSION}`, {
    method: "GET"
  });
  if (response.ok) {
    response = await response.json();
    setUserData({ userId: response["userId"], nickname: response["nickname"] });
    tempUserCluster = response["selectedCluster"];
    tokensLeft = response["tokens_left"];
    tempUserTrial = response["tempUserTrial"];
    if (!localStorage.getItem("registered") && !response["userId"].includes("temp")) {
      localStorage.setItem("registered", true);
    }
  }
  var isTempUser = userData["userId"] && userData["userId"].includes("temp");
  if (
    !isTempUser &&
    (userData === undefined ||
      !userData["nickname"] ||
      !userData["userId"] ||
      response.status !== 200 ||
      response.nickname !== userData["nickname"])
  ) {
    window.location.href = window.location.href;
    return;
  }
  if ($(this).attr("data-href")) {
    var pageUrl = $(this).attr("data-href");
    if (pageUrl.indexOf("account.html") > -1) {
      ["userId", "nickname", "lastAnalysisDate"].forEach(item => {
        var params = {};
        params[item] = "";
        setUserData(params);
      });
      $("#main-menu-container, #open-mobile-menu-btn").addClass("hidden invisible");
      setTimeout(() => {
        window.location.reload();
      }, 900);
      return;
    } else if (pageUrl == "analyse.html") {
      if (e.type == "click" && getUserData("takingTour") == "1" && getUserData("tourStep") == "analysis") {
        TourMessageManager.updateStep("run");
      }
    }
    if ($(this).attr("id") == "header-info-text") {
      singleElementTransition("#header-info", false);
    }
    navigateToPage(pageUrl);
  } else {
    navigateToPage($(this).attr("href"));
  }
});

$(window).on("popstate", function() {
  CustomModal.closeModal();
  var href = this.location.href;
  navigateToPage(href, false);
});

function initPage(page) {
  page = page.replace("/", "").split("?")[0];
  if (
    userId &&
    userId.includes("temp") &&
    ![
      "topics.html",
      "analyse.html",
      "topic.html",
      "popup.html",
      "share.html",
      "import.html",
      "validation.html",
      "account.html"
    ].includes(page)
  ) {
    window.location.href = "topics.html";
    return;
  }
  if (page == "topic.html") {
    initTopicPage();
  } else if (page == "topics.html") {
    $("#header-info").removeClass("transparent");
    initTopicsPage();
  } else if (page == "tab.html") {
    initTabPage();
  } else if (page == "analyse.html") {
    initAnalysePage();
  } else if (page == "import.html") {
    initImportPage();
  } else if (page == "search.html") {
    initSearchPage();
  } else if (page == "closed_tabs.html") {
    isWebVersion() ? navigateToPage("topics.html") : initClosedTabsPage();
  } else if (page == "settings.html") {
    initSettingsPage();
  } else if (page == "account.html") {
    var getParams = new URLSearchParams(window.location.search);
    !nickname || !userId || userId.includes("temp") || getParams.get("type") == "reset"
      ? initAccountPage()
      : (window.location.href = "topics.html");
  } else if (page == "statistics.html") {
    initStatisticsPage();
  } else if (page == "validation.html") {
    initIndexPage();
  } else if (page == "history.html") {
    initHistoryPage();
  } else if (page == "favourite.html") {
    initFavouritePage();
  } else if (page == "contacts.html") {
    initContacts();
  } else if (page.includes("share.html")) {
    initSharePage();
  }
}

window.navigateToPage = function(href, addToHistory = true) {
  var element = "main";
  var hrefFragments = href.split("/");
  var href = hrefFragments[hrefFragments.length - 1];
  $(element).addClass("transparent");
  CustomModal.closeModal();

  if (addToHistory) {
    window.history.pushState(null, null, href);
  }

  clearInterval(interval);
  if (progressInterval) {
    clearInterval(progressInterval);
  }
  if (summaryInterval) {
    clearInterval(summaryInterval);
  }
  if (breakdownInterval) {
    clearInterval(breakdownInterval);
  }

  $.ajax({
    url: href,
    type: "GET"
  }).done(function(data) {
    preloader(false, "body");
    var container = $(data).closest(element).length ? $(data).closest(element) : $(data).find(element);
    if (container.length) {
      setTimeout(() => {
        document.title = $(data)
          .filter("title")
          .text();
        $(element).replaceWith(container.prop("outerHTML"));
        processHeader();
        initPage(href);
      }, 400);
    }
  });
};

if (!isMobile()) {
  $.widget("ui.tooltip", $.ui.tooltip, {
    options: {
      classes: {
        "ui-tooltip": "ui-tooltip-custom"
      },
      items: "[data-title]",
      content: function() {
        if ($(this).closest(".calendar-table").length > 0) {
          return false;
        }
        return this.getAttribute("data-title").replace(/\\n/gm, "<br />");
      },
      position: {
        my: "center bottom",
        at: "center top-10",
        collision: "flipfit"
      },
      show: false,
      hide: false
    }
  });
}

function initHeader(tabs) {
  userData = getUserData();
  if (isWebVersion() || userId.includes("temp")) {
    $("#header-info").remove();
    return;
  }
  if (window.location.href.indexOf("analyse.html") > -1) {
    return;
  }
  var tabsObject = getBrowser(true);
  if (tabsObject) {
    var lastAnalysisDate = getLastDate(tabs, true, userData["lastAnalysisDate"]);
    if (!lastAnalysisDate.isNew) {
      return;
    } else if (lastAnalysisDate == "") {
      $("#header-info").remove();
    }
    $("#token-count-span").text(tokensLeft);
    $("#last-refresh-span").text(lastAnalysisDate.formatted);
    setUserData({ lastAnalysisDate: lastAnalysisDate.raw });
    singleElementTransition("#header-info", true);
  } else {
    $("#header-info").remove();
  }
}

function processHeader() {
  userData = getUserData();
  userId = userData["userId"];
  nickname = userData["nickname"];
  if (window.location.href.indexOf("popup.html") > -1) {
    return;
  }
  var isMobileDevice = isMobile();
  if (!nickname) {
    $("#header-info").addClass("hidden invisible");
  }
  if (isMobileDevice) {
    $("#header-info").remove();
  }
  if (window.location.href.indexOf("analyse.html") > -1) {
    singleElementTransition("#header-info", false);
    return;
  }
  if (!nickname || userId.includes("temp")) {
    if (!$("#account-nav .login").length) {
      $("#account-nav")
        .append("<a class='login transition'>Log in</a>")
        .append("<a class='sign-up transition'>Sign up</a>");
      var urlParams = new URLSearchParams(window.location.search);
      var formType = urlParams.get("type");
      if (userId && userId.includes("temp")) {
        formType = "sign-up";
      }
      if (formType && formType !== "reset") {
        $(`#account-nav .${formType}`).addClass("hidden invisible");
      } else {
        $("#account-nav .login").addClass("vertical-line");
      }
      initNavAuthBtns();
    }
  }

  if (userData["lastAnalysisDate"] && window.location.href.indexOf("account.html") == -1) {
    var lastAnalysisDate = getLastDate([], true, userData["lastAnalysisDate"]);
    $("#last-refresh-span").text(lastAnalysisDate.formatted);
    singleElementTransition("#header-info", true);
  } else {
    $("#header-info").addClass("hidden invisible");
  }
}

function initTopUpBtn() {
  $("#topup-btn").on("click", function() {
    window.open(
      !isWebVersion() && getBrowser() == "safari" && typeof browser != "undefined"
        ? "tabcrunch://"
        : `https://tabcrunch.com/pricing.html?userId=${userId}`,
      "_blank"
    );
  });
}

function initNavAuthBtns() {
  $("#account-nav").on("click", ".login, .sign-up", function() {
    var formType = $(this).hasClass("login") ? "login" : "sign-up";
    if (userId && userId.includes("temp")) {
      setUserData({ userId: "", nickname: "", registered: true });
      window.location.href = window.location.href;
    }
    navigateToPage(`account.html?type=${formType}`);
    singleElementTransition(`#account-nav .${formType}`, false);
    setTimeout(() => {
      var elementToShow = formType == "login" ? ".sign-up" : ".login";
      if (formType == "login") {
        $("#account-nav .login").removeClass("vertical-line");
      }
      singleElementTransition(`#account-nav ${elementToShow}`, true);
    }, 350);
  });
}

function processMenu() {
  if (window.location.href.indexOf("popup.html") > -1) {
    return;
  }
  var userData = getUserData();
  if (!userData["userId"] || !userData["nickname"] || window.location.href.indexOf("account.html") > -1) {
    $("#main-menu-container, #open-mobile-menu-btn").addClass("hidden invisible");
    $("#main-menu-container").removeClass("hide");
  } else {
    $("#main-menu-container, #open-mobile-menu-btn").removeClass("hidden invisible");
    if (userData["userId"].includes("temp")) {
      for (const option of $(".menu-option")) {
        var optionElement = $(option);
        var optionName = optionElement.find("span").attr("id");
        if (
          ((optionName === "tab-analyse" || optionName === "tab-import") && tempUserTrial) ||
          optionName === "tab-categories"
        ) {
          continue;
        }
        if (optionName === "tab-logout") {
          optionElement.addClass("hidden invisible");
          continue;
        }
        optionElement.addClass("temp-user");
        optionElement.find(".lock-menu").removeClass("hidden invisible");
      }
    } else {
      $("#expanded-menu-container #tab-logout").text(`Log out (${userData["nickname"]})`);
    }
  }
  $("#open-menu-btn-conainer, #close-menu-btn, #open-mobile-menu-btn, #close-mobile-menu-btn").on("click", function() {
    if (
      $(this)
        .attr("id")
        .includes("open")
    ) {
      $("#menu-options-container .menu-option span").addClass("page-link");
      if (getUserData("takingTour") == "1" && !isMobile() && !isWebVersion()) {
        CustomModal.closeModal("#tour-modal .modal-content-holder");
        setTimeout(() => {
          TourMessageManager.initByStep(["menu"], "analysis");
        }, 1000);
      }
    } else {
      $("#menu-options-container .menu-option span").removeClass("page-link");
    }
    triggerMenuAnimation();
  });
  $(document).keyup(function(e) {
    if (
      KEY_CODES.escape === e.keyCode &&
      $("#menu-move").hasClass("expanded") &&
      !localStorage.getItem("menuClicked")
    ) {
      localStorage.setItem("menuClicked", true);
      triggerMenuAnimation(e.keyCode);
    }
  });
}

function triggerMenuAnimation(keyCode = null, link = "", showMainAfter = true) {
  var menuIsExpanded = $("#menu-move").hasClass("expanded");
  if (menuIsExpanded || keyCode) {
    $("#expanded-menu-container").addClass("transparent");
  } else {
    userData = getUserData();
    var container = $("#expanded-menu-container");
    container.find("#tab-logout").text(`Log out (${userData["nickname"]})`);
    container.removeClass("hidden");
    $("main, #header-info, #account-nav, #nickname-header").addClass("transparent");
    singleElementTransition(".pop-up-message", false);
    if (isWebVersion()) {
      $("#closed-tabs-link")
        .parents(".menu-option")
        .addClass("hidden");
    }
  }
  if ($("#main-menu-container").css("display") != "none") {
    $("#main-menu-container").toggleClass("hide");
  } else {
    $(
      menuIsExpanded ? "#close-menu-btn, #close-mobile-menu-btn" : "#open-menu-btn-conainer, #open-mobile-menu-btn"
    ).toggleClass("invisible");
  }
  setTimeout(() => {
    $("#menu-background").toggleClass("fill");
    $("#menu-move").toggleClass("expanded");
    $($("#main-menu-container").css("display") != "none" ? "#close-menu-btn" : "#close-mobile-menu-btn").toggleClass(
      "hidden"
    );
    $(
      $("#main-menu-container").css("display") != "none" ? "#open-menu-btn-conainer" : "#open-mobile-menu-btn"
    ).toggleClass("hidden");
    if (!menuIsExpanded) {
      $("main").addClass("invisible");
    }
  }, 300);
  setTimeout(() => {
    if (menuIsExpanded) {
      $("#expanded-menu-container").addClass("hidden");
      var elementToShow =
        link.indexOf("account.html") == -1 && link.indexOf("analyse.html") == -1 ? ", #header-info" : "";
      if (showMainAfter) {
        $(`main, #account-nav, #nickname-header ${elementToShow}`).removeClass("transparent");
      }
      if (link.indexOf("account.html") == -1) {
        $("main").removeClass("invisible");
      }
      localStorage.removeItem("menuClicked");
    } else {
      $("#expanded-menu-container").removeClass("transparent");
    }
  }, 600);

  setTimeout(() => {
    if (window.location.href.indexOf("account.html") == -1) {
      if ($("#main-menu-container").css("display") != "none") {
        $("#main-menu-container").toggleClass("hide");
      } else {
        $(
          menuIsExpanded ? "#open-menu-btn-conainer, #open-mobile-menu-btn" : "#close-menu-btn, #close-mobile-menu-btn"
        ).toggleClass("invisible");
      }
    }
  }, 1000);
}

function checkUserAccessToPage(page) {
  userData = getUserData();
  userId = userData["userId"];
  nickname = userData["nickname"];
  if (!userId && !localStorage.getItem("registered")) {
    userId = "temp_" + crypto.randomUUID();
    setUserData({ userId, nickname: userId });
  } else if (!userData || !userId || !nickname) {
    handleUserAccess(page, false);
    return;
  }
  fetch(API_URL + "/users/" + userId + `?api_version=${API_VERSION}`, { method: "GET", headers: HEADERS })
    .then(response => {
      if (response && response.status === 200) {
        response.json().then(data => {
          handleUserAccess(page, data["active"] === 2 && data["nickname"] == userData["nickname"]);
          setUserData({ userId: data["userId"], nickname: data["nickname"] });
          tempUserCluster = data["selectedCluster"];
          tokensLeft = data["tokens_left"];
          tempUserTrial = data["tempUserTrial"];
          $("#paid-analysis").removeClass("invisible");
          $("#token-count-span").text(tokensLeft);
          if (!localStorage.getItem("registered") && !data["userId"].includes("temp")) {
            localStorage.setItem("registered", true);
          }
        });
      } else {
        setUserData({ nickname: "", userId: "" });
        handleUserAccess(page, false);
      }
    })
    .catch(_err => {
      handleUserAccess(page, false);
    });
}

async function handleUserAccess(page, hasCredentials) {
  initTopUpBtn();
  if (page.includes("topics") && (await analysisCompleted())) {
    processHeader();
    processMenu();
    navigateToPage("topics.html");
    return;
  }
  var isAllowedPage = ["validation", "account", "pop", "share"].some(path => page.includes(path));
  var isTempUser = userId && userId.includes("temp");
  if (!isAllowedPage && !hasCredentials && !isTempUser && localStorage.getItem("registered")) {
    setUserData({ nickname: "", userId: "" });
    window.location.href = "account.html?type=login";
  } else {
    processHeader();
    processMenu();
    var hrefFragments = page.split("/");
    var href = hrefFragments[hrefFragments.length - 1];
    initPage(href);

    var userData = getUserData();
    if (!isMobile() && !isWebVersion() && (!userData.tourFinished || parseInt(userData.tourFinished) != 1)) {
      var lastReminder = userData.lastTourReminder;
      if (lastReminder) {
        lastReminder = parseInt(lastReminder);
      }
      if (new Date().getTime() - lastReminder < 8 * 3600000) {
        setUserData({ takingTour: 0, tourFinished: 0 });
      } else {
        setUserData({ takingTour: 1, tourFinished: 0 });
      }
    }
  }
}

async function analysisCompleted() {
  var urlParams = new URLSearchParams(window.location.search);
  var userId = urlParams.get("id");
  var timestamp = urlParams.get("ts");
  var secret = urlParams.get("sec");
  if (userId && timestamp && secret) {
    if (Number(timestamp) + 24 * 60 * 60 * 1000 < new Date().getTime() / 1000) {
      return false;
    }
    var response = await fetch(API_URL + "/analysis_completed/" + userId + `?api_version=${API_VERSION}`, {
      method: "POST",
      headers: HEADERS,
      body: JSON.stringify({ timestamp, secret })
    });
    if (response.ok) {
      var data = await response.json();
      setUserData({ nickname: data["nickname"], userId: data["userId"] });
      return true;
    }
    return false;
  } else {
    return false;
  }
}

export function addAnalysisStatusMessage(status) {
  if ($(".no-data-wrapper").length) {
    if (!$("#no-data-container").length) {
      $(".no-data-wrapper").append(`<div id="no-data-container"><div>`);
    }
    var messageText =
      !status || ["completed", "failed", "rate_limit_reached"].indexOf(status) > -1
        ? `No tabs have been analysed yet. <span data-page="analyse.html" class="text-link">Run analysis</span> or <span class="text-link" data-page="import.html?p=import">import tabs</span>`
        : `<span class="bigger-font">Tab analysis in progress…</span><br/><span>Your tab groups will appear once the analysis is completed.</span>`;
    $("#no-data-container").html(`${messageText}`);
    $("#no-data-container .text-link").on("click", function() {
      navigateToPage($(this).attr("data-page"));
    });
  }
}

export function getGroupsData(data, interval) {
  var colors = [...Object.values(TOPIC_COLORS)];
  var maxColors = colors.length;
  clearInterval(interval);
  if (data.urls) {
    var date = getLastDate(data.urls, true);
    if (date) {
      setUserData({
        lastAnalysisDate: date.raw
      });
    }
  }
  if (data.tokens_left != undefined) {
    tokensLeft = data.tokens_left;
  }
  if (
    !data.clusters ||
    !data.clusters.length ||
    !data.urls.length ||
    !data.urls.length ||
    ["completed", "failed", "READY"].indexOf(data.status) == -1
  ) {
    addAnalysisStatusMessage(data.status);
    return data.status != null ? data.status : "";
  }
  var groups = data.clusters.map(e => ({ ...e, tabs: [] }));
  var tabs = data.urls;
  for (var tab of tabs) {
    for (var i in groups) {
      if (groups[i].name == "Uncategorized") {
        groups[i].name = "Other";
        groups[i].summary = "Tabs that are not related to any of the existing groups.";
      }
      if (groups[i].id === tab.cluster_id) {
        groups[i].tabs.push(tab);
        tab.readTime = tab.readTime ? parseInt(tab.readTime) : 0;
        groups[i].readTime = groups[i].readTime ? groups[i].readTime + tab.readTime : tab.readTime;
      }
      groups[i].color = colors[i % maxColors];
    }
  }

  groups = groups.filter(groupData => {
    return groupData.tabs.length;
  });
  initHeader(tabs);
  return groups;
}

export function getLastDate(tabs, isShortVersion = false, lastDate = undefined) {
  if (lastDate) {
    lastDate = new Date(lastDate);
  }
  var hasNewDate = false;
  var months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
  var timeOffset = Math.round(new Date().getTimezoneOffset() / 60).toString();
  for (var tabData of tabs) {
    var createdDate = tabData.created ? tabData.created.replace("T", " ") : "";
    if (!lastDate || lastDate < new Date(createdDate)) {
      hasNewDate = true;
      lastDate = new Date(createdDate);
    }
  }
  var date = "";
  if (lastDate) {
    var localDate = new Date(lastDate);
    localDate.setHours(localDate.getHours() - timeOffset);
    if (isShortVersion) {
      return {
        raw: lastDate,
        formatted: `${months[localDate.getMonth()]} ${localDate.getDate()}`,
        isNew: hasNewDate
      };
    }
    for (var dateSegment of [localDate.getDate(), localDate.getMonth() + 1]) {
      date += (dateSegment < 10 ? `0${dateSegment}` : dateSegment) + ".";
    }
    date += localDate.getFullYear() + " at ";
    for (var dateSegment of [localDate.getHours(), localDate.getMinutes()]) {
      date += (dateSegment < 10 ? `0${dateSegment}` : dateSegment) + ":";
    }
    date = date.slice(0, -1);
  }
  return {
    raw: lastDate,
    formatted: date,
    isNew: hasNewDate
  };
}

export function logTabs(tabs, userId, callback = undefined) {
  var uniqueId = userId;
  var tabs = getOnlyValidTabs(tabs);
  var isPopUp = $("#analyse-wrapper").length;
  var browserType = getBrowser();
  var browserObject = getBrowser(true);
  if (!browserType) {
    browserType = "extension";
  }
  var duplicatedTabs = {};
  var uniqueTabsMap = tabs.reduce((acc, tab) => {
    if (!acc[tab.url]) {
      acc[tab.url] = tab;
    } else if (!tab.pinned) {
      if (!duplicatedTabs[tab.url]) {
        duplicatedTabs[tab.url] = tab;
        duplicatedTabs[tab.url]["count"] = 1;
      } else {
        duplicatedTabs[tab.url]["count"] += 1;
      }
    }
    return acc;
  }, {});
  tabs = Object.values(uniqueTabsMap);
  if (Object.values(duplicatedTabs).length && browserObject) {
    var listItemsContents = [];
    for (var tabData of Object.values(duplicatedTabs)) {
      var domain = new URL(tabData.url).hostname;
      var domainText = tabData.title ? ` - ${domain}` : "";
      var tabTitle = tabData.title ? tabData.title : domain;
      listItemsContents.push(`
        ${tabTitle}${domainText} (${tabData.count} ${tabData.count > 1 ? "duplicates" : "duplicate"})
      `);
    }
    var duplicateListHTML = addCustomOrderedList(listItemsContents);
    new CustomModal(
      `<span class="text-black">You have duplicated tabs. Only one of each duplicated tab will be analysed. Do you want to close the duplicates before running the analysis? The following duplicates will be closed:</span>
      <ol class="custom-markers-list">${duplicateListHTML}</ol>`,
      "",
      `<button class="run-without-closing duplicate-btn border-btn">Run without closing</button>
      <button class="close-tabs duplicate-btn gradient-btn">Close tabs and run</button>`,
      { customId: "list-modal" }
    );

    var duplicatedTabsIds = Object.values(duplicatedTabs).map(tab => tab.id);
    $(".close-tabs").on("click", function() {
      browserObject.remove(duplicatedTabsIds);
      reloadAndSendTabContent();
      CustomModal.closeModal(this);
    });
    $(".run-without-closing").on("click", function() {
      reloadAndSendTabContent();
      CustomModal.closeModal(this);
    });
  } else {
    reloadAndSendTabContent();
  }

  function reloadAndSendTabContent() {
    var browserType = getBrowser();
    var deviceName = getDeviceName();
    if (browserType != "chrome") {
      var tabList = [];
      try {
        for (var tab of tabs) {
          tabList.push({
            tabTitle: tab.title,
            tabId: tab.id.toString(),
            tabUrl: tab.url,
            tabContent: "",
            tabSource: deviceName ? deviceName : "Computer"
          });
        }
        startAnalysis(() => {
          fetch(API_URL + "/tabs/" + uniqueId + `?api_version=${API_VERSION}`, {
            method: "POST",
            headers: HEADERS,
            body: JSON.stringify(tabList)
          }).then(response => {
            preloader(false, isPopUp ? "#content-container" : "body");
            if (response.status !== 200) {
              new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
              return;
            }
            if (callback) {
              callback();
            }
          });
        });
      } catch (error) {
        new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
      }
    } else {
      setTimeout(() => {
        preloader(true, "body", "Processing tabs. Please wait.");
      }, 300);
      var reloadPromiseLits = [];
      if (browserObject) {
        for (var tab of tabs) {
          if (!tab.discarded && tab.status != "unloaded") {
            continue;
          }
          reloadPromiseLits.push(timeout(10000, browserObject.reload(tab.id, {})));
        }
      }

      setTimeout(() => {
        Promise.allSettled(reloadPromiseLits).then(function() {
          var browserObject = getBrowser(true, false);
          startAnalysis(() => {
            preloader(false, isPopUp ? "#content-container" : "body");
            browserObject
              ? browserObject.runtime.sendMessage({
                  type: "getTabsContent",
                  tabs,
                  uniqueId,
                  deviceName: deviceName
                })
              : undefined;
            if (callback) {
              callback();
            }
          });
        });
      }, 6000);
    }
  }
}

export function startAnalysis(successCallback) {
  var uniqueId = getUserData("userId");
  fetch(API_URL + "/set_analysis_start_status/" + uniqueId + `?api_version=${API_VERSION}`, {
    method: "POST",
    headers: HEADERS
  }).then(response => {
    if (response.status !== 200) {
      if (response.status === 402) {
        showInsufficientTokensMessage();
        $("#custom-modal #close-modal-icon").click(function() {
          window.location.reload();
        });
        $("#custom-modal .btn").click(function() {
          window.open(
            !isWebVersion() && getBrowser() == "safari" && typeof browser != "undefined"
              ? "tabcrunch://"
              : `https://tabcrunch.com/pricing.html?userId=${userId}`,
            "_blank"
          );
          window.location.reload();
        });
        return;
      }
      new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
      return;
    } else {
      successCallback();
    }
  });
}

export function transition(invisibleElement, hiddenElements, visibleElements) {
  $(invisibleElement).addClass("invisible");
  setTimeout(() => {
    $(hiddenElements).addClass("hidden");
    $(visibleElements).removeClass("hidden");
  }, 300);
  setTimeout(() => {
    $(visibleElements).removeClass("invisible");
  }, 450);
}

export function goBack() {
  $("form").on("click", ".form-back-btn", function() {
    var sectionId = $(this)
      .parents("form")
      .attr("id");
    if (sectionId != "auth-info") {
      var previousSection = PREVIOUS_POPUP_SECTION[sectionId];
      transition(`#${sectionId}`, `#${sectionId}`, `#${previousSection}`);
      if (sectionId === "sign-up-code") {
        setUserData({ userId: "" });
      } else if (sectionId == "forgot-section") {
        setTimeout(() => {
          $("#email-forgot, #forgot-section .form-info").removeClass("hidden");
        }, 350);
      }
    } else {
      transition(`#${sectionId}`, `#${sectionId}`, "");
    }
    $(".popup-wrapper .invalid").addClass("invisible");
  });
}

export function inlineLiveSearchFormEvent(element, clearSearch = false) {
  var searchArray = [];
  $("#clear-search-btn").toggleClass("invisible", !element.value);
  searchArray.push(element.value ? element.value.toLowerCase() : "");
  var liveTableInstance = $(".live-table-wrapper").data("liveTableInstance");
  if (liveTableInstance) {
    if (clearSearch) {
      $(element)
        .parents(".inline-search-form")
        .find("input")
        .val("");
    }
    liveTableInstance.setFilter(searchArray, true);
  }
}

export function getOnlyValidTabs(tabs) {
  return tabs.filter(tabData => {
    return tabData.url && tabData.url.match(/https?:\/\/*/) && tabData.url.indexOf("tabcrunch.com") == -1;
  });
}

export function getUserData(params = []) {
  if (params.length) {
    if (typeof params == "string") {
      return localStorage.getItem(params);
    }
    var data = {};
    for (var key of params) {
      data[key] = localStorage.getItem(key);
    }
    return data;
  }
  return { ...localStorage };
}

export function setUserData(params = {}) {
  for (var key of Object.keys(params)) {
    if (params[key] || params[key] === 0) {
      localStorage.setItem(key, params[key]);
    } else {
      localStorage.removeItem(key);
    }
  }
}

export function showRegisterMessage() {
  new CustomModal(
    ` <h1>Register for free</h1>
        <div class="info">
          <div class="unlock-icon icon"></div>
          <div>Unlock all features</div>
        </div>
        <div class="info">
          <div class="gift-icon icon"></div>
          <div>Get 10 free analysis</div>
        </div>
        <p>Enough to group and summarise thousands of tabs.</p>`,
    "",
    `<button class="temp-user-register">Register</button>`,
    { customId: "temp-user-modal" }
  );
  $("#temp-user-modal .temp-user-register").click(function() {
    window.open(`https://tabcrunch.com/pricing.html?userId=${userId}`, "_blank");
    $("#temp-user-modal #close-modal-icon").click(function() {
      window.location.reload();
    });
  });
}

export function showInsufficientTokensMessage() {
  new CustomModal(
    `You've used up your paid analysis.
    To run a new analysis, you need to top up.`,
    "",
    `<button class="border-btn btn">Top up now</button>`
  );
}

export function showNamingDialog(startAnalysis = null, tabsForAnalysis = null) {
  var deviceName = getDeviceName();
  if (deviceName) {
    return;
  }
  new CustomModal(
    `It looks like you are using a new device to access TabCrunch. <br> Give it a unique name, so that we can show you which tabs came from which device.
        <div id="device-name-holder"><div>Device name: </div><input type="text" id="device-name-input" /></div>`,
    "New device? Let's name it.",
    `<button id="save-device-name" class="gradient-btn">Save device name</button>`,
    { disableDefaultClose: true, lazyClose: false }
  );
  $("#device-name-input").on("keyup", function(e) {
    if (e.keyCode === KEY_CODES.enter) {
      setDeviceName($(this).val(), startAnalysis, tabsForAnalysis);
      TourMessageManager.initByPage();
    }
  });
  $("#save-device-name").on("click", function() {
    setDeviceName($("#device-name-input").val(), startAnalysis, tabsForAnalysis);
    TourMessageManager.initByPage();
  });
  $("#custom-modal #close-modal-icon").addClass("hidden invisible");
}

function setDeviceName(deviceNameValue, startAnalysis, tabsForAnalysis) {
  if (deviceNameValue.length) {
    var deviceName = getDeviceName(false);
    localStorage.setItem(
      "deviceName",
      JSON.stringify({ ...deviceName, [userId.replace("temp_", "")]: deviceNameValue })
    );
    CustomModal.closeModal(this);
    if (startAnalysis && tabsForAnalysis) {
      setTimeout(() => {
        initMinTabsMessage(startAnalysis, tabsForAnalysis);
      }, 150);
    }
  }
}

export function getDeviceName(forCurrentUser = true) {
  var deviceName = localStorage.getItem("deviceName");
  var userId = getUserData("userId");
  if (deviceName) {
    deviceName = JSON.parse(deviceName);
    return forCurrentUser ? deviceName[userId.replace("temp_", "")] : deviceName;
  }
}

$("body").on("click", 'a[target="_blank"]', function(event) {
  if (!isWebVersion() && !window.location.href.includes("topic")) {
    event.preventDefault();
    getBrowser(true).create({
      url: $(this).attr("href"),
      active: true
    });
  }
});

if (!isWebVersion() && getBrowser() == "safari" && typeof browser != "undefined") {
  if (!localStorage.getItem("UUID")) {
    browser.runtime.sendNativeMessage("application.id", { message: "GetAppleUUID" }, function(response) {
      localStorage.setItem("UUID", response);
    });
  }
  if (userId && localStorage.getItem("UUID")) {
    fetch(API_URL + "/sync_apple_payment", {
      method: "POST",
      headers: HEADERS,
      body: JSON.stringify({ userId, uuid: localStorage.getItem("UUID") })
    });
  }
}
