import { transition, goBack, getOnlyValidTabs, getUserData, setUserData } from "./panel.js";
import { updateAnalysisProgress, updateGraph } from "./analyse.js";
import { getBrowser } from "./common.js";
import { API_URL, API_VERSION } from "./config.js";

var allTabs = [];
var userData = {};
var userId = undefined;
var nickname = undefined;

window.isPopupInit = true;

getTabs();

async function initPage() {
  userData = getUserData();
  userId = userData["userId"];
  nickname = userData["nickname"];
  var response = await fetch(API_URL + "/users/" + userData["userId"] + `?api_version=${API_VERSION}`, {
    method: "GET"
  });
  if (response.ok) {
    response = await response.json();
    setUserData({ userId: response["userId"], nickname: response["nickname"] });
    if (!localStorage.getItem("registered") && !response["userId"].includes("temp")) {
      localStorage.setItem("registered", true);
    }
  }
  if (userId && response.status !== 200) {
    setUserData({ userId: "", nickname: "" });
    window.location.reload();
    return;
  }
  if (getBrowser() != "chrome") {
    $("#new-tabs-text").html(`You have <span id="new-tabs-count"></span> opened tabs.`);
    $("#last-analysis-info-container, #unanalysed-tabs-text").remove();
  }

  initUnanalysedListButtons();
  goBack();
  $("#content-container").tooltip();

  $("#bubble-info-holder").on("mouseover", function() {
    $("#graphic-container").toggleClass("hovered");
  });
  $("#bubble-info-holder").on("mouseout", function() {
    $("#graphic-container").toggleClass("hovered");
  });
  if (userId && nickname) {
    checkProgress();
    $("#logo")
      .parent()
      .attr("href", "topics.html")
      .addClass("link");
  } else {
    var allTabsCount = allTabs.length;
    $("#analysed-tabs-count").text(0);
    $("#analyse-info-text").text(" tabs analysed");
    $("#new-tabs-count").text(allTabsCount);
    $("#view-topics, #view-tabs-list").addClass("hidden");
    $("#analyse-wrapper").removeClass("invisible");
    $("#bubble-info-holder").addClass("inner-glow");
    transition(
      "#analyse-progress, #results-bubble-text",
      "#analyse-progress, #results-bubble-text",
      "#analyse-reults, #run-btn"
    );
  }

  $("#login, #sign-up, #sign-up-code, #user-details, #forgot-section").on("keyup", "input", function(e) {
    var error = $(this)
      .parent()
      .find(".invalid");
    if (!error.hasClass("invisible") && e.key !== "Enter") {
      error.addClass("invisible");
    }
  });
}

function getTabs() {
  var tabsObject = getBrowser(true);
  if (tabsObject) {
    tabsObject.query({}, function(currentTabs) {
      allTabs = getOnlyValidTabs(currentTabs);
      initPage();
    });
  } else {
    initPage();
  }
}

function checkProgress() {
  if (getBrowser() == "chrome") {
    var progressInterval = setInterval(() => {
      updateAnalysisProgress(progressInterval, allTabs, "popup");
    }, 10000);
    if (isPopupInit) {
      updateAnalysisProgress(progressInterval, allTabs, "popup");
    }
  } else {
    $("#new-tabs-count").text(allTabs.length);
    transition("", "", `#analyse-wrapper, #run-btn, #view-topics, #view-tabs-list, #analyse-reults`);
    setTimeout(() => {
      updateGraph(100, 100, "popup");
    }, 1000);
  }
}

function initUnanalysedListButtons() {
  $("#view-unanalysed").on("click", function() {
    transition(
      "#graphic-container, #analyse-info-holder, #welcome-message",
      "#graphic-container, #analyse-info-holder, #welcome-message",
      "#unanalysed-list-container"
    );
  });
  $("#unanalysed-back-btn").on("click", function() {
    transition("#unanalysed-list-container", "#unanalysed-list-container", "#graphic-container, #analyse-info-holder");
  });
}
