import { API_VERSION, API_URL, VALIDATION_MESSAGES } from "./config.js";
import { getGroupsData, getUserData, inlineLiveSearchFormEvent, setUserData } from "./panel.js";
import { escapeHTML, closeTabsFromButton, numberFormatter, preloader } from "./common.js";
import { initRowCell, initColumns } from "./topic.js";

window.interval = undefined;
var groups = [];
var tabsData = [];
var uniqueId = undefined;
var userData = {};
var searchLiveTable = undefined;

var callback = function(callsCount) {
  fetch(API_URL + "/search/" + uniqueId + `?api_version=${API_VERSION}`, { method: "GET" })
    .then(response => response.json())
    .then(data => getGroupsData(data, interval))
    .then(data => {
      preloader(false, "body");
      groups = typeof data == "object" ? data : [];
      initPage();
      clearInterval(interval);
    })
    .catch(error => {
      if (!$(".preloader").length) {
        preloader(true, "body");
      }
      if (callsCount == 5) {
        new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
      }
      console.error(error);
    });
};

export function initSearchPage() {
  userData = getUserData();
  uniqueId = userData["userId"];
  var callsCount = 0;
  interval = setInterval(function() {
    callsCount += 1;
    callback(callsCount);
  }, 5000);
  callback(callsCount);
}

function initPage() {
  tabsData = [];
  for (var group of groups) {
    var tabs = group.tabs;
    for (var i in tabs) {
      var tab = tabs[i];
      var domain = tab.url.indexOf("://") > -1 ? tab.url.split("/")[2] : tab.url.split("/")[0];
      domain = domain.replace(/https?:\/\//, "");
      tab.domain = domain;
      tab.groupId = group.id;
      tab.groupName = group.name;
      tabsData.push(tab);
    }
  }
  var tableData = initTableData();
  searchLiveTable = initTable(tableData);

  $("#search-main").removeClass("transparent");
  $("main").tooltip();
  $("#search-tab-field").attr("placeholder", "Search for keywords in the URL, title, or body");
}

function removeTab(tabData) {
  return function(_closeBtn, _event) {
    var tabCloseData = [
      {
        id: tabData.tabId,
        url: tabData.url,
        createdDate: tabData.createdDate,
        closedDate: new Date().toString(),
        title: tabData.title
      }
    ];
    if (!uniqueId) {
      uniqueId = getUserData("userId");
    }
    closeTabsFromButton(tabCloseData, uniqueId, () => {
      searchLiveTable.removeRow("tabId", tabData.tabId);
      $(".tabs-count").text(numberFormatter(searchLiveTable.data.length));
    });
  };
}

function initTableData() {
  var tableData = [];
  for (var tab of tabsData) {
    tab.closeCallback = removeTab(tab);
    var rowData = {
      tabId: initRowCell(tab.tabId, "tabId", tab),
      x: initRowCell("", "x", tab),
      favourite: initRowCell(tab.isFavourite, "favourite", tab),
      searchSummary: initRowCell(tab.hasSummary, "searchSummary", tab),
      title: initRowCell(escapeHTML(tab.title), "title", tab),
      content: initRowCell(tab.content, "content"),
      domain: initRowCell(tab.domain, "domain"),
      group: initRowCell(tab.groupId, "group", tab)
    };
    tableData.push(rowData);
  }
  return tableData;
}

function initTable(tableData) {
  var searchedValue = getUserData("tabSearch");
  if (searchedValue) {
    $("#search-tab-field").val(searchedValue);
    $("#clear-search-btn").removeClass("invisible");
  }

  var columns = initColumns(["x", "favourite", "title", "group", "searchSummary"]);
  var liveTable = new LiveTable(".live-table", tableData, {
    columns: columns,
    searchType: "content",
    noSorting: ["x", "favourite"],
    noData: "No matching tabs found.",
    filter: searchedValue ? [searchedValue] : "",
    callOnFilter: updateMatchCount
  });
  $("#search-tab-field").on("keyup", function() {
    inlineLiveSearchFormEvent(this, false);
  });

  $("#clear-search-btn").on("click", function() {
    var inputElement = $(this)
      .parents(".search-container")
      .find("input");
    inputElement.val("");
    inlineLiveSearchFormEvent(inputElement[0], true);
    $("#clear-search-btn").addClass("invisible");
    $("#results-count-container").addClass("invisible");
    setUserData({ tabSearch: "" });
  });
  return liveTable;
}

function updateMatchCount(rowData) {
  var matches = rowData.filter(row => row.__visible);
  var matchesCount = matches.length;
  var matchesText = matches.length > 1 ? "tabs found" : "tab found";
  if (matchesCount) {
    $("#results-count").text(`${matchesCount} ${matchesText}`);
    $("#results-count-container").removeClass("invisible");
  } else {
    $("#results-count-container").addClass("invisible");
  }
}
