/**
 * Class for all section toggles functions
 */

export class SectionToggle {
  static init(section, inputName, text, isEnabled) {
    var sectionElement = $(section);
    var checked = isEnabled ? "checked='checked'" : "";
    sectionElement.addClass("section-toggle-container");
    sectionElement.html(`
            <label class="section-toggle" data-info="${section.substring(1)}">
                <input type="checkbox" name="${inputName}" value="1" ${checked} />
                <div data-title="${isEnabled ? "Disable" : "Enable"}" class="toggle-content ${
      isEnabled ? "active" : ""
    }">
                    <span></span>
                        <div class="toggle-handle"></div>
                    <span></span>
                </div>
            </label>
            <span class="toggle-label">${text}</span>
            `);
    sectionElement.find("label").on("change", function() {
      SectionToggle.handleToggle(this);
    });
  }

  static handleToggle(element) {
    var selectedElement = $(element);
    if (selectedElement.find("input").is(":checked")) {
      selectedElement.find(".toggle-content").addClass("active");
      selectedElement.find(".toggle-content").attr("data-title", "Disable");
    } else {
      selectedElement.find(".toggle-content").removeClass("active");
      selectedElement.find(`input[type="checkbox"]`).removeAttr("checked");
      selectedElement.find(".toggle-content").attr("data-title", "Enable");
    }
  }
}
