import {
  API_VERSION,
  API_URL,
  SITE_URL,
  HEADERS,
  VALIDATION_MESSAGES,
  PASSWORD_MIN_LENGTH,
  EMAIL_REG_EXPRESSION,
  NICKNAME_MIN_LENGTH
} from "./config.js";
import { getUserData, setUserData } from "./panel.js";
import { SectionToggle } from "./section-toggle.js";
import {
  isWebVersion,
  addPopupMessage,
  singleElementTransition,
  getOpenAIStatus,
  addOpenAIMessage,
  preloader
} from "./common.js";

var uniqueId = undefined;
var settings = undefined;
window.interval = undefined;
var userData = {};

var callback = function(callsCount) {
  fetch(API_URL + "/settings/" + uniqueId + `?api_version=${API_VERSION}`, { method: "GET" })
    .then(async response => {
      if (!response.ok) {
        var message = VALIDATION_MESSAGES.serverError;
        if (response.status < 500) {
          var data = await response.json();
          message = data["detail"];
        }
        throw new Error(message);
      }
      return response.json();
    })
    .then(data => {
      preloader(false, "body");
      if (data.status == "success") {
        clearInterval(interval);
        settings = data.settings;
        $("#nickname").val(data.nickname);
        $("#email").val(data.email);
        initPage();
      }
    })
    .catch(error => {
      if (!$(".preloader").length) {
        preloader(true, "body");
      }
      if (callsCount == 5) {
        if (!$("#custom-modal").is(":visible")) {
          new CustomModal(error.message, "", "");
        }
      }
    });
};

export function initSettingsPage() {
  userData = getUserData();
  uniqueId = userData["userId"];
  var callsCount = 0;
  interval = setInterval(function() {
    callsCount += 1;
    callback(callsCount);
  }, 5000);
  callback(callsCount);
}

async function initPage() {
  new QRCode($("#qrcode")[0], {
    text: `${SITE_URL}/validation.html?id=${userData["userId"]}`,
    width: 128,
    height: 128
  });
  for (var setting of Object.keys(settings)) {
    var settingElement = $(`.option-control input[name='${setting}']`);
    if (setting == "trackClosedTabs" && !isWebVersion()) {
      singleElementTransition("#track-closed-tabs", true);
      SectionToggle.init("#track-closed-tabs", "trackClosedTabs", "Remember closed tabs.", settings[setting]);
    } else if (setting == "groupsSortField") {
      $(`#groups-sort-selector option[value='${settings[setting]}'`).prop("selected", "selected");
    } else if (setting == "tabsSortField") {
      $(`#tabs-sort-selector option[value='${settings[setting]}'`).prop("selected", "selected");
    } else if (setting === "country") {
      var element = $("#country-selector");
      for (var key in COUNTRIES) {
        var countryName = COUNTRIES[key];
        var selected = key.toLowerCase() === settings[setting] ? "selected" : "";
        var option = `<option value="${key.toLowerCase()}" ${selected}>${countryName}</option>`;
        element.append(option);
        if (selected) {
          element.width(countryName.length * 7 + "px");
        }
      }
    }
    if (settingElement.length && settings[setting]) {
      settingElement.prop("checked", "checked");
    }
  }
  initSettingsSubmit();
  initExportLastUrlsButton();
  $("#app-store-link").on("click", function() {
    window.open("https://apps.apple.com/app/tabcrunch/id6476495158", "_blank");
  });

  // Report a bug button
  $("#bug-wrapper button").click(function() {
    window.open("https://github.com/TabCrunch/tabs-issues", "_blank");
  });

  // Clear current tab data button
  $("#clear-wrapper button").click(function() {
    new CustomModal(
      `You are about to delete all current tab groups and tab-related data?
      This action cannot be undone. Are you sure you want to continue?`,
      "",
      `<button class="cancel border-btn">Cancel</button>
      <button class="continue gradient-btn">Continue</button>`
    );
    $("#custom-modal .continue").click(function() {
      $("#custom-modal #close-modal-icon").click();
      resetUserData();
    });
    $("#custom-modal .cancel").click(function() {
      $("#custom-modal #close-modal-icon").click();
    });
  });

  // Delete account button
  $("#delete-wrapper button").click(function() {
    new CustomModal(
      `Are you sure you wish to delete your account? <br/>This will pernamently erase your account and all tab-related data.`,
      "Delete Account",
      "delete"
    );
    $("#custom-modal .delete").click(function() {
      $("#custom-modal #close-modal-icon").click();
      fetch(API_URL + "/delete_user/" + uniqueId + `?api_version=${API_VERSION}`, { method: "POST" })
        .then(() => {
          addPopupMessage("deleteAccount");
        })
        .catch(() => {
          new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
        });
    });
    $("#custom-modal .cancel").click(function() {
      $("#custom-modal #close-modal-icon").click();
    });
  });

  $("#password").on("click", function() {
    if ($(this).val() == ".......") {
      $(this).val("");
    }
  });
  $("input")
    .keyup(resizeInput)
    .each(resizeInput);
  $("main").tooltip();
  var openAIStatus = await getOpenAIStatus();
  addOpenAIMessage(openAIStatus, ".page-title");
  $("#settings-main").removeClass("transparent");
}

function resizeInput() {
  $(this).attr("size", $(this).val().length);
}

function initExportLastUrlsButton() {
  $("#archived-wrapper button").on("click", function() {
    fetch(API_URL + "/logs/" + uniqueId + `?api_version=${API_VERSION}`, {
      method: "GET"
    })
      .then(response => {
        if (response.status !== 200) {
          new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
          return;
        }
        response.json().then(data => {
          if (!data.data) {
            new CustomModal(VALIDATION_MESSAGES.noLogs, "", "");
            return;
          }
          var content = data.data;
          var contentObject = new Blob(["\ufeff", content], { type: `text/csv` });
          var url = URL.createObjectURL(contentObject);
          var link = document.createElement("a");
          link.setAttribute("href", url);
          link.setAttribute("target", "_blank");
          link.setAttribute("download", `TabCrunch_${userData["nickname"]}_tabs.csv`);
          document.body.appendChild(link);
          if (!isWebVersion()) {
            var iframe = document.querySelector("#download-link-container");
            var iframeDocument = iframe.contentDocument || iframe.contentWindow.document;
            iframeDocument.body.appendChild(link);
          }
          link.click();
          link.remove();
        });
      })
      .catch(() => {
        new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
      });
  });
}

function initSettingsSubmit() {
  $(".section-toggle input, .option-control select").on("change", function() {
    handleSettingsUpdate(this);
    if ($(this).attr("id") === "country-selector") {
      var element = $(this);
      var countryName = element.find("option:selected").text();
      element.width(countryName.length * 7 + "px");
    }
  });
  $("#save-btn").on("click", function(event) {
    event.preventDefault();
    var password = $("#password").val();
    if (password != ".......") {
      if (password.length < PASSWORD_MIN_LENGTH) {
        singleElementTransition("#login-wrapper .invalid", true);
        $("#login-wrapper .invalid").text(VALIDATION_MESSAGES.singlePassswordLength);
        return;
      } else {
        fetch(API_URL + "/reset/" + uniqueId + `?api_version=${API_VERSION}`, {
          method: "POST",
          headers: HEADERS,
          body: JSON.stringify({ password })
        })
          .then(function(response) {
            if (response.status >= 500) {
              throw new Error(VALIDATION_MESSAGES.serverError);
            }
          })
          .catch(error => {
            new CustomModal(error.message, "", "");
          });
      }
    }

    if (
      !$("#email")
        .val()
        .match(EMAIL_REG_EXPRESSION)
    ) {
      singleElementTransition("#login-wrapper .invalid", true);
      $("#login-wrapper .invalid").text(VALIDATION_MESSAGES.email);
      return;
    }
    if ($("#nickname").val().length < NICKNAME_MIN_LENGTH) {
      singleElementTransition("#login-wrapper .invalid", true);
      $("#login-wrapper .invalid").text(VALIDATION_MESSAGES.nicknameLength);
      return;
    }
    handleLoginInfoUpdate();
  });

  $("#email, #password, #nickname").on("keyup", function(e) {
    var error = $("#login-wrapper .invalid");
    if (!error.hasClass("invisible") && e.key !== "Enter") {
      error.addClass("invisible");
    }
  });
}

function handleSettingsUpdate() {
  var settings = {};
  $(".section-toggle input").each(function() {
    settings[$(this).attr("name")] = $(this).prop("checked") ? "1" : "0";
  });
  $(".option-control select").each(function() {
    settings[$(this).attr("name")] = $(this).val();
  });
  fetch(API_URL + "/settings/" + uniqueId + `?api_version=${API_VERSION}`, {
    method: "POST",
    headers: HEADERS,
    body: JSON.stringify(settings)
  })
    .then(function(response) {
      if (!response.ok) {
        throw new Error("");
      }
      response.json().then(function(data) {
        if (data.status && data.status == "success") {
          addPopupMessage("settingUpdate");
          for (var setting of Object.keys(settings)) {
            var param = {};
            param[setting] = settings[setting];
            setUserData(param);
          }
        } else {
          new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
        }
      });
    })
    .catch(() => {
      new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
    });
}

function handleLoginInfoUpdate() {
  var data = {
    email: $("#login-wrapper [name='email']").val(),
    nickname: $("#login-wrapper [name='nickname']").val()
  };
  fetch(API_URL + "/edit_user/" + uniqueId + `?api_version=${API_VERSION}`, {
    method: "POST",
    headers: HEADERS,
    body: JSON.stringify(data)
  })
    .then(function(response) {
      if (!response.ok) {
        throw new Error("");
      }
      response.json().then(function(data) {
        if (data.nickname) {
          addPopupMessage("loginDataUpdate");
          setUserData({ nickname: data.nickname });
        } else {
          new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
        }
      });
    })
    .catch(() => {
      new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
    });
}

function resetUserData() {
  fetch(API_URL + "/reset_user_data/" + uniqueId + `?api_version=${API_VERSION}`, { method: "GET" })
    .then(function(response) {
      if (response.status >= 500) {
        throw new Error(VALIDATION_MESSAGES.serverError);
      }
      if (response && response.status === 200) {
        $("#custom-modal #close-modal-icon").click();
        addPopupMessage("clearTabs");
        setUserData({
          lastAnalysisDate: ""
        });
      }
    })
    .catch(() => {
      new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
    });
}
