import { addCustomOrderedList } from "./common.js";
import { API_URL, VALIDATION_MESSAGES } from "./config.js";

export function initSharePage() {
  var urlParams = new URLSearchParams(window.location.href.split("?")[1]);
  var shareKey = decodeURIComponent(urlParams.get("links"));
  fetch(API_URL + "/share/" + shareKey, { method: "GET" })
    .then(function(response) {
      if (response.status >= 500) {
        throw new Error(VALIDATION_MESSAGES.serverError);
      }
      if (response.status == 403) {
        $(".list-wrapper").append('<div id="no-data-container">The tabs are no longer available for sharing.</div>');
        $("#share-main").removeClass("transparent");
      }
      if (response && response.status === 200) {
        response.json().then(data => {
          var listItemContents = [];
          $("#group-name").text(data.cluster);
          for (var tabData of data.urls) {
            var tabTitle = tabData.title ? tabData.title : tabData.url.replace(/https?:\/\//, "");
            listItemContents.push(`<a href="${tabData.url}" target="_blank">${tabTitle}</a>`);
          }
          addCustomOrderedList(listItemContents, $("#shared-links-container"), ["share-link"]);
          $("#share-main").removeClass("transparent");
        });
      }
    })
    .catch(error => {
      console.error(error);
      new CustomModal(VALIDATION_MESSAGES.serverError);
    });
}
