import {
  API_VERSION,
  API_URL,
  SITE_URL,
  HEADERS,
  VALIDATION_MESSAGES,
  SYSTEM_GENERATED_CATEGORIES,
  KEY_CODES,
  POPUP_MESSAGES
} from "./config.js";
import { getGroupsData, inlineLiveSearchFormEvent, getUserData, setUserData, showRegisterMessage } from "./panel.js";
import {
  isMobile,
  getBrowser,
  isWebVersion,
  openTabOrUrl,
  bookmarkTabs,
  addPopupMessage,
  singleElementTransition,
  numberFormatter,
  formatMinutes,
  escapeHTML,
  closeTabsFromButton,
  initActionsMenu,
  toggleShareLinkContainer,
  initButtonAdditionalContainerClose
} from "./common.js";
import { closeTabs } from "./topics.js";
import { downloadExportedFile } from "./import.js";
import { TourMessageManager } from "./tour.js";

var uniqueId = undefined;
var groups = [];
var groupId = undefined;
var groupData = [];
var tabsData = [];
var linksData = [];
var websitesData = {};
var columnsRenamed = {
  website: "Websites",
  "website-group": "Websites",
  title: "Tabs",
  dateAdded: "Date added",
  readTime: "Reading time",
  tabsCount: "Tabs count",
  summary: "Summary",
  searchSummary: "Summary",
  color: "Group",
  language: "Language",
  x: "Close",
  favourite: "Fav.",
  group: "Group"
};
var columnsLinks = [];
var columnsWebsites = ["x", "color", "#", "website-group", "readTime", "tabsCount"];
var liveTable = undefined;
var userData = {};

var callback = function() {
  $("#back-link").attr("href", "topics.html?id=" + groupId);
  fetch(API_URL + "/status/" + uniqueId + `?api_version=${API_VERSION}`, { method: "GET" })
    .then(response => response.json())
    .then(data => getGroupsData(data))
    .then(data => {
      groups = typeof data == "object" ? data : [];
      groupData = groups.filter(group => {
        return group.id == groupId;
      })[0];
      fetch(API_URL + "/cluster_similarity/" + uniqueId + `?api_version=${API_VERSION}`, {
        method: "POST",
        headers: HEADERS,
        body: JSON.stringify({ clusterId: groupId })
      })
        .then(function(response) {
          if (!response.ok) {
            throw new Error("The similar tabs can't be generated right now. Please try again later.");
          }
          return response.json();
        })
        .then(function(data) {
          if (data.status === "success") {
            var similarTabs = data.similarity || {};
            for (var tab of groupData.tabs) {
              tab.overlap = similarTabs[tab.tabId] ? parseInt(similarTabs[tab.tabId]) : 0;
            }
            initPage();
          }
        })
        .catch(function(_err) {
          initPage();
        });
    })
    .catch(() => {
      new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
    });
};

export function initTopicPage() {
  userData = getUserData();
  uniqueId = userData["userId"];
  groupId = parseInt(window.location.href.split("id=")[1].split("&")[0]);
  columnsLinks = ["x", "color", "favourite", "#", "title", "summary", "readTime", "website", "language", "dateAdded"];
  callback();
}

function updateCharts(data, isInit = false) {
  var tabChartData = {};
  var readTimeChartData = [];
  var overlapChartData = [];
  var isWebsiteData = data.length && data[0]["website-group"];
  for (var i in data) {
    var tab = data[i];
    var id = isWebsiteData ? tab["website-group"].value : `Tab ${parseInt(i) + 1}`;
    var overlapLabel = isWebsiteData ? tab["website-group"].value.replace(/https?:\/\//, "") : `Tab ${parseInt(i) + 1}`;
    readTimeChartData.push({ id, value: tab.readTime.value });
    overlapChartData.push({ id: overlapLabel, value: tab.overlap ? tab.overlap.value : 0 });

    if (isInit && !isWebsiteData) {
      var domain = tab.website.value;
      if (!tabChartData[domain]) {
        tabChartData[domain] = {
          id: domain.replace(/https?:\/\//, ""),
          value: 1
        };
      } else {
        tabChartData[domain]["value"] += 1;
      }
    }
  }
  if (isInit) {
    Charts.initPieChart(readTimeChartData, "time-chart", "Reading time", "reading-time");
    Charts.initPieChart(Object.values(tabChartData), "tabs-chart", "Tabs per website", "websites");
    Charts.initAreaChart(overlapChartData, "overlap-chart", "Content overlap");
  } else {
    Charts.updateChart(readTimeChartData, "time-chart");
    Charts.updateChart(overlapChartData, "overlap-chart");
  }
}

function initPage() {
  // Redirect if the group is now empty
  if (!groupData) {
    navigateToPage("topics.html");
    return;
  }

  linksData = [];
  websitesData = {};
  tabsData = groupData["tabs"];
  var tabsWithTitles = tabsData.filter(tab => {
    return (tab.title && tab.title.trim()) || tab.readTime;
  });
  if (!tabsWithTitles.length) {
    columnsLinks = columnsLinks.filter(col => {
      return ["summary", "readTime", "language"].indexOf(col) == -1;
    });
    columnsWebsites = columnsWebsites.filter(col => {
      return ["readTime"].indexOf(col) == -1;
    });
    $("#time-chart")
      .parents(".chart-wrapper")
      .addClass("hidden");
    $("#overlap-chart")
      .parents(".chart-wrapper")
      .addClass("hidden");
  }
  if (groupData.name == SYSTEM_GENERATED_CATEGORIES["other"]) {
    $("#overlap-chart")
      .parents(".chart-wrapper")
      .addClass("hidden");
  }
  if (groupData.name == SYSTEM_GENERATED_CATEGORIES["missingPage"]) {
    columnsLinks = columnsLinks.filter(col => {
      return ["summary", "readTime", "language"].indexOf(col) == -1;
    });
    columnsWebsites = columnsWebsites.filter(col => {
      return ["readTime"].indexOf(col) == -1;
    });
    $("#time-chart")
      .parents(".chart-wrapper")
      .addClass("hidden");
    $("#overlap-chart")
      .parents(".chart-wrapper")
      .addClass("hidden");
  }
  var urlParams = new URLSearchParams(window.location.search);
  var redirectParam = urlParams.get("redirect");
  if (redirectParam) {
    $("#back-link").attr("href", redirectParam == "2" ? "search.html" : "statistics.html");
  }
  initTableData();
  initTable();
  updateCharts(liveTable.data, true);
  $("#tabs-table-holder").removeClass("transparent");
  initViewToggle();
  $(".main-header .title").text(groupData.name);
  $(".summary-container .summary").text(groupData.summary);
  var readingTime = groupData.tabs.reduce((acc, tab) => acc + (tab.readTime || 0), 0);
  var languages = Object.entries(
    groupData.tabs.reduce(
      (acc, tab) => (tab.language ? { ...acc, [tab.language]: (acc[tab.language] || 0) + 1 } : acc),
      {}
    )
  )
    .sort((a, b) => b[1] - a[1])
    .map(([language]) => language)
    .join(", ")
    .toUpperCase();
  $(".languages").text(languages ? languages : "N/A");
  $(".reading-time").text(readingTime ? formatMinutes(readingTime) : "N/A");
  $(".tabs-count").text(numberFormatter(groupData.tabs.length));
  $(".main-header .group-color").css({ "background-color": groupData.color });
  initEditButton();
  initBreakdownButton();
  initShareButton();
  initBookmarkButton();
  initActionsMenu();
  initOpenTabsButton();
  $(".transition-container").removeClass("transparent");
  $("#close-tabs-btn").on("click", function() {
    $(this).attr("data-group", groupId);
    closeTabs(groupData.tabs, $(this));
  });
  $("#view-back-btn").on("click", function() {
    $("#view-domains").trigger("click");
    $("#view-back-btn-container").addClass("transparent");
    setTimeout(() => {
      $("#view-back-btn-container").addClass("hidden");
      $("#view-toggle").removeClass("hidden");
    }, 300);
    setTimeout(() => {
      $("#view-toggle").removeClass("transparent");
    }, 500);
  });
  $("#search-tab-field").on("keyup", function() {
    inlineLiveSearchFormEvent(this, false);
  });
  $("#clear-search-btn").on("click", function() {
    var inputElement = $(this)
      .parents(".search-container")
      .find("input");
    inputElement.val("");
    inlineLiveSearchFormEvent(inputElement[0], true);
    $("#clear-search-btn").addClass("invisible");
  });
  $(".export-btn").on("click", function() {
    downloadExportedFile("csv", [groupData], groupData.name);
  });

  $("main").tooltip();
  $("#topic-main").removeClass("transparent");
  TourMessageManager.initByPage();
}

function initShareButton() {
  $(".share-btn").on("click", function() {
    var shareUrl = `${SITE_URL}/share.html?links=${encodeURIComponent(groupData.shareKey)}`;
    toggleShareLinkContainer(shareUrl);
  });
}

function initOpenTabsButton() {
  var tabsObject = getBrowser(true);
  if (!tabsObject) {
    $("#open-link-btn").remove();
    $("#actions-dropdown-container").removeClass("one-less-option");
    $("#actions-dropdown-container").addClass("two-less-options");
    return;
  }

  $("#open-link-btn").on("click", function() {
    if (tabsData.length > 30) {
      new CustomModal(
        "You are about to open over 30 tabs in your browser. This may cause your device to run slower. Are you sure you wish to open all tabs in your browser?",
        "",
        `<button id="confirm-open-tabs" class="btn border-btn">Yes, open tabs in browser</button>
        <button id="cancel-open-tabs" class="btn gradient-btn">Cancel</button>`
      );
      $("#confirm-open-tabs").on("click", function() {
        openTabs();
        CustomModal.closeModal();
      });
      $("#cancel-open-tabs").on("click", function() {
        CustomModal.closeModal();
      });
    } else {
      openTabs();
    }

    function openTabs() {
      $("#custom-modal #close-modal-icon").click();
      var tabsObject = getBrowser(true);
      var urls = tabsData.map(tab => tab.url);
      try {
        tabsObject.query({}, function(tabs) {
          var openedUrl = tabs.map(tab => tab.url);
          var urlsToOpen = urls.filter(url => openedUrl.indexOf(url) == -1);
          for (var url of urlsToOpen) {
            tabsObject.create({ url, active: false });
          }
          addPopupMessage(urlsToOpen.length ? "tabsOpen" : "tabsAlreadyOpen");
        });
      } catch (err) {
        addPopupMessage("tabOpenError");
      }
    }
  });
}

function initEditButton() {
  var clusterName = $(".main-header .title").text();
  if (Object.values(SYSTEM_GENERATED_CATEGORIES).indexOf(clusterName) != -1) {
    $(".edit-btn").removeClass("hidden");
    return;
  }
  singleElementTransition(".edit-btn", true);
  $(".edit-btn").on("click", function() {
    clusterName = $(".main-header .title").text();
    if (clusterName) {
      $("#edit-group-btn, #edit-close-btn").unbind("click");
      var editGroup = $("#edit-group");
      var editGroupBtn = $("#edit-group-btn");
      editGroup.val(clusterName);
      singleElementTransition("#share-container", false);
      singleElementTransition("#edit-container", true);
      initButtonAdditionalContainerClose("edit-btn", "#edit-container");
      editGroup.on("keyup", function(e) {
        if (e.keyCode === KEY_CODES.enter) {
          editGroupBtn.trigger("click");
        }
      });
      editGroupBtn.on("click", function() {
        var newClusterName = editGroup.val();
        if (newClusterName && newClusterName !== clusterName) {
          var urlParams = new URLSearchParams(window.location.search);
          var clusterId = urlParams.get("id");
          var cluster = { clusterName: newClusterName, clusterId };
          fetch(API_URL + "/edit_clusters/" + uniqueId + `?api_version=${API_VERSION}`, {
            method: "POST",
            headers: HEADERS,
            body: JSON.stringify(cluster)
          })
            .then(function(response) {
              response.json().then(function(data) {
                if (data.status && data.status === "OK") {
                  $(".main-header .title").text(newClusterName);
                  addPopupMessage("titleEdit");
                  $("body").off("click");
                }
              });
            })
            .catch(function(_error) {
              addPopupMessage("titleEditError");
            });
        }
        singleElementTransition("#edit-container", false);
      });
    }
  });
}

function initBreakdownButton() {
  if (Object.values(SYSTEM_GENERATED_CATEGORIES).includes(groupData["name"]) || uniqueId.includes("temp")) {
    return;
  }
  if (tabsData.length > 15) {
    var breakdownBtn = $(".breakdown-btn");
    singleElementTransition(".breakdown-btn", true);
    breakdownBtn.on("click", function() {
      var currentBreakdownNames = !userData["breakdownNames"] ? [] : JSON.parse(userData["breakdownNames"]);
      if (!currentBreakdownNames.includes(groupData["name"])) {
        currentBreakdownNames.push(groupData["name"]);
      }
      setUserData({
        breakdownNames: JSON.stringify(currentBreakdownNames)
      });
      fetch(API_URL + "/single_cluster_tabs/" + uniqueId + `?api_version=${API_VERSION}`, {
        method: "POST",
        headers: HEADERS,
        body: JSON.stringify({ clusterId: groupId.toString() })
      })
        .then(function(response) {
          if (response.ok) {
            window.location.href = "topics.html";
          }
        })
        .catch(() => {
          new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
        });
    });
  }
}

function initBookmarkButton() {
  if (getBrowser() == "safari" || isMobile() || isWebVersion()) {
    $(".bookmark-btn").remove();
    $("#actions-dropdown-container").addClass("one-less-option");
    return;
  }
  $(".bookmark-btn").on("click", function() {
    var bookmarks = groupData.tabs.map(tabData => {
      return { url: tabData.url, title: tabData.title };
    });
    bookmarkTabs(bookmarks, groupData.name);
  });
}

function initTableData() {
  var i = 1;
  for (var tab of tabsData) {
    var domain = tab.url.indexOf("://") > -1 ? tab.url.split("/")[2] : tab.url.split("/")[0];
    domain = domain.replace(/https?:\/\//, "");
    var rowData = {
      tabId: initRowCell(tab.tabId, "tabId", tab),
      color: initRowCell(groupData.color, "color"),
      "#": i++,
      x: initRowCell("", "x", tab),
      favourite: initRowCell(tab.isFavourite, "favourite", tab),
      website: initRowCell(domain, "website"),
      title: initRowCell(escapeHTML(tab.title), "title", tab),
      dateAdded: initRowCell(tab.created ? tab.created : "", "dateAdded"),
      readTime: initRowCell(tab.readTime, "readTime"),
      summary: initRowCell(tab.hasSummary, "summary", tab),
      overlap: initRowCell(tab.overlap, "overlap"),
      language: initRowCell(tab.language ? tab.language.toUpperCase() : "N/A", "language")
    };
    linksData.push(rowData);
    if (!websitesData[domain]) {
      websitesData[domain] = {
        "website-group": domain,
        tabsCount: 1,
        readTime: tab.readTime,
        overlap: tab.overlap
      };
    } else {
      websitesData[domain]["tabsCount"] += 1;
      websitesData[domain]["readTime"] += tab.readTime;
      websitesData[domain]["overlap"] += tab.overlap;
    }
  }

  i = 1;
  for (var domain of Object.keys(websitesData)) {
    var websiteData = websitesData[domain];
    websiteData.overlap /= websiteData.tabsCount.toFixed(2);
    var rowData = {
      color: initRowCell(groupData.color, "color"),
      "#": i++,
      x: initRowCell("", "x"),
      "website-group": initRowCell(websiteData["website-group"], "website-group"),
      tabsCount: initRowCell(websiteData["tabsCount"], "tabsCount"),
      readTime: initRowCell(websiteData["readTime"], "readTime")
    };
    rowData["overlap"] = { value: websiteData.overlap, text: websiteData.overlap.toString() };
    websitesData[domain] = rowData;
  }
  websitesData = Object.values(websitesData);
}

function initTable() {
  var isSingleTopic = $("#view-links").hasClass("selected") || !$("#view-back-btn-container").hasClass("transparent");
  var columns = initColumns(isSingleTopic ? columnsLinks : columnsWebsites);
  var tableData = isSingleTopic ? linksData : websitesData;
  var orderBy =
    userData["tabsSortField"] &&
    columns.filter(columnData => {
      return columnData.name == userData["tabsSortField"];
    }).length
      ? userData["tabsSortField"]
      : "readTime";
  liveTable = new LiveTable(".live-table", tableData, {
    columns: columns,
    sorting: orderBy,
    order: ["title", "website", "website-group"].indexOf(orderBy) == -1 ? "desc" : "asc",
    noSorting: ["x", "color", "favourite"],
    callOnSort: isSingleTopic ? updateCharts : () => {},
    noData: "Well done, nothing left to read here."
  });
  $("#search-tab-field").attr("placeholder", "Search tabs");
  var search = $("#search-tab-field");
  if (search.val()) {
    liveTable.setFilter([search.val()], true);
  }
  updateCharts(liveTable.data);
}

export function initRowCell(value, column, data = {}) {
  if (!value && value !== 0) {
    value = "";
  }
  if (column == "dateAdded") {
    var dateFragments = value.split("-");
    var dateFormated = "";
    if (dateFragments.length > 1) {
      dateFragments[2] = dateFragments[2].split("T")[0];
      dateFormated = dateFragments[2].split("T")[0] + "." + dateFragments[1] + "." + dateFragments[0];
    }
    return {
      value: value,
      searchValue: dateFormated,
      text: dateFormated,
      class: column
    };
  } else if (column == "website-group") {
    return {
      value: value,
      text: value,
      __onClick: initWebsiteGroupLink,
      class: "link"
    };
  } else if (column == "color") {
    return {
      value: value,
      text: value,
      __onClick: initMoveDropdown
    };
  } else if (column == "x") {
    return {
      value: value,
      text: value,
      __onClick: data.closeCallback ? data.closeCallback : initCloseTabBtn
    };
  } else if (column == "favourite") {
    return {
      value: value,
      text: value
    };
  } else if (column == "title") {
    if (!value.trim()) {
      value = data.url.replace(/https?:\/\//, "");
    }
    var text = value && value.length > 90 ? value.slice(0, 90) + "..." : value;
    return {
      value: value,
      text: `<a class="link" target="_blank" href="${data.url}" data-tab-id="${data.tabId}" data-title="Visit page">${text}</a>`,
      class: column,
      __onClick: initTabOpen
    };
  } else if (column == "readTime") {
    return {
      value: value,
      text: formatMinutes(value),
      class: column
    };
  } else if (column == "summary") {
    return {
      value: value,
      text: value
        ? `<a class="link page-link" href="tab.html?id=${data.tabId}&t=${groupId}">View summary</a`
        : `<a class="link page-link" href="tab.html?id=${data.tabId}&t=${groupId}">Request summary</a>`,
      __onClick: redirectToSummary,
      class: "summary"
    };
  } else if (column == "searchSummary") {
    return {
      value: value,
      text: value
        ? `tab.html?id=${data.tabId}&t=${data.cluster_id}&redirect=2`
        : `tab.html?id=${data.tabId}&t=${data.cluster_id}&redirect=2`
    };
  } else if (column == "tabsCount") {
    return {
      value: value,
      text: numberFormatter(value),
      class: column
    };
  } else if (column == "domain" || column == "content") {
    return {
      value: "",
      text: "",
      searchValue: value ? value.toLowerCase() : ""
    };
  } else if (column == "group") {
    return {
      value: value,
      text: `<a class="link" href="topic.html?id=${value}&redirect=2">${data.groupName}</a>`,
      sortValue: data.groupName
    };
  } else {
    return {
      value: value,
      text: value,
      class: column
    };
  }
}

function redirectToSummary(_element, event) {
  var userId = getUserData("userId");
  if (!userId || userId.includes("temp")) {
    event.preventDefault();
    event.stopPropagation();
    showRegisterMessage();
  }
  if (isMobile() || isWebVersion()) {
    return;
  }
  if (getUserData("takingTour") == "1" && ["editTitle", "share", "summary"].indexOf(getUserData("tourStep")) != -1) {
    TourMessageManager.updateStep("favourite");
  }
}

export function initColumns(columnNames, orderBy) {
  var result = [];
  var order = ["title", "website", "website-group"].indexOf(orderBy) == -1 ? "desc" : "asc";
  for (var column of columnNames) {
    var columnData = {
      name: column,
      text: columnsRenamed[column] ? columnsRenamed[column] : column,
      default: order
    };
    if (column == "x") {
      columnData["title"] = isWebVersion() ? "Delete tab from TabCrunch" : "Close tab in browser and TabCrunch";
    }
    result.push(columnData);
  }
  return result;
}

function initViewToggle() {
  $("#view-toggle #view-domains").on("click", function() {
    $(this).addClass("selected");
    $("#view-toggle #view-links").removeClass("selected");
    $("#tabs-table-holder").addClass("transparent");
    setTimeout(() => {
      initTable();
    }, 300);
    setTimeout(() => {
      $("#tabs-table-holder").removeClass("transparent");
    }, 500);
  });

  $("#view-toggle #view-links").on("click", function() {
    $(this).addClass("selected");
    $("#view-toggle #view-domains").removeClass("selected");
    $("#tabs-table-holder").addClass("transparent");
    setTimeout(() => {
      initTable();
    }, 300);
    setTimeout(() => {
      $("#tabs-table-holder").removeClass("transparent");
    }, 500);
  });
}

function initWebsiteGroupLink(_element, _event) {
  var website = this.text;
  var linksForDomainData = linksData.filter(linkData => {
    return linkData["website"]["value"] == website;
  });
  var columns = initColumns(columnsLinks);
  $("#tabs-table-holder").addClass("transparent");
  $("#view-toggle").addClass("transparent");
  $("#back-to-domain").text(website);
  setTimeout(() => {
    var orderBy = "readTime";
    liveTable = new LiveTable(".live-table", linksForDomainData, {
      columns: columns,
      sorting: orderBy,
      order: ["title", "website", "website-group"].indexOf(orderBy) == -1 ? "desc" : "asc",
      noSorting: ["x", "color", "favourite"],
      callOnSort: updateCharts
    });
    updateCharts(liveTable.data);
    $("#view-toggle").addClass("hidden");
    $("#view-back-btn-container").removeClass("hidden");
  }, 300);
  setTimeout(() => {
    $("#tabs-table-holder").removeClass("transparent");
    $("#view-back-btn-container").removeClass("transparent");
  }, 500);
}

function initMoveDropdown(selectedTab, _event) {
  if ($("#move-dropdown-container").length) {
    $("#move-dropdown-container").remove();
  }
  $("#move-container-holder").removeClass("hidden");
  addMoveDropdownHtml(selectedTab);
  initButtonAdditionalContainerClose("group-color", "#move-dropdown-container");
  var tabData = getSelectedTabs($(selectedTab).closest("tr"));
  var tabIds = tabData.map(tab => tab.id);
  $("#move-dropdown-container .move-to-topic").each(function() {
    $(this).on("click", function() {
      var clusterId = parseInt($(this).attr("data-topic"));
      var topicName = $(this).attr("data-name");
      fetch(API_URL + "/reorder/" + uniqueId + `?api_version=${API_VERSION}`, {
        method: "POST",
        headers: HEADERS,
        body: JSON.stringify({ clusterId, tabIds })
      })
        .then(function(response) {
          response.json().then(function(data) {
            if (data.status && data.status == "success") {
              addPopupMessage("tabMove", {
                group: topicName,
                tabsCount: tabIds.length
              });
              singleElementTransition("#move-dropdown-container", false);
            } else {
              addPopupMessage("tabMoveError");
            }
          });
        })
        .catch(function(_error) {
          addPopupMessage("tabMoveError");
        });
      updateTableData(tabIds);
      $("#move-dropdown-container").remove();
    });
  });
}

function addMoveDropdownHtml(selectedTab) {
  var topicsHtml = "";
  var sortedGroups = groups.sort((group1, group2) => (group2.name.toLowerCase() < group1.name.toLowerCase() ? 1 : -1));
  for (var topicData of sortedGroups) {
    if (topicData.id == groupId) {
      continue;
    }
    var tabCount = topicData.tabs.length;
    topicsHtml += `<div data-topic="${topicData.id}" class="move-to-topic" data-name="${topicData.name}">
    <div class="group-name-and-color">
      <span class="group-color" style="background-color: ${topicData.color}"></span>
      <span class="group-name">${topicData.name}</span>
    </div>
    <div class="tab-count-and-icon">
      <span class="tab-count">${tabCount} </span>
      <img class="icon-img" src="images/tabs_count.svg">
    </div>
  </div>
  `;
  }
  var isSingleTopic = $("#view-links").hasClass("selected") || $("#view-toggle").hasClass("hidden");
  var tabText = isSingleTopic ? "tab" : "tabs";
  var html = `<div id="move-dropdown-container" class="invisible transition">
        <span id="move-title">Move ${tabText} to:</span>
        <div id="topics-container">
            ${topicsHtml}
        </div>
    </div>`;
  $("#move-container-holder").append(html);

  var offsetPoint = $(selectedTab).parents("td");
  var containerHeight = parseInt($("#tabs-table-holder").outerHeight());
  var rowPosition = offsetPoint.position().top;
  var containerScroll = document.querySelector("#tabs-table-holder").scrollTop;
  var buttonOffset = containerScroll ? rowPosition - containerScroll : rowPosition;
  $("#move-dropdown-container").css({
    bottom: containerHeight - buttonOffset + "px"
  });
  singleElementTransition("#move-dropdown-container", true);
}

function updateTableData(tabsToRemove) {
  linksData = [];
  websitesData = {};
  var newTabsData = [];
  for (var tab of tabsData) {
    if (tabsToRemove.indexOf(tab.tabId) === -1) {
      newTabsData.push(tab);
    }
  }
  tabsData = newTabsData;
  initTableData();
  initTable();
}

function getSelectedTabs(rowElement) {
  var isSingleTopic =
    !$("#view-links").length || $("#view-links").hasClass("selected") || $("#view-toggle").hasClass("hidden");
  var tabData = [];
  if (isSingleTopic) {
    var tabDateDetails = rowElement
      .find(".dateAdded")
      .text()
      .split(".");
    var createdDate = new Date(rowElement.find(".title").attr("data-created")).toString();
    tabData.push({
      id: rowElement.find(".title .link").attr("data-tab-id"),
      url: rowElement.find(".link").attr("href"),
      createdDate: createdDate,
      closedDate: new Date().toString(),
      title: rowElement.find(".link").text()
    });
  } else {
    var selectedWebsite = rowElement.find(".group-color").attr("data-website");
    for (var tab of tabsData) {
      if (tab.url.indexOf(selectedWebsite) > -1) {
        var tabDateDetails = tab.created.split("T")[0].split("-");
        var createdDate = new Date(
          parseInt(tabDateDetails[0]),
          parseInt(tabDateDetails[1]) - 1,
          parseInt(tabDateDetails[2])
        ).toString();
        tabData.push({
          id: tab.tabId,
          url: tab.url,
          createdDate: createdDate,
          closedDate: new Date().toString(),
          title: tab.title
        });
      }
    }
  }
  return tabData;
}

function initCloseTabBtn(closeBtn, _event) {
  var tabElement = $(closeBtn).closest("tr");
  var tabsData = getSelectedTabs(tabElement);
  if (!tabsData.length) {
    addPopupMessage("tabCloseNotFound");
    return;
  }
  var tabIds = tabsData.map(tab => tab.id);
  if (!uniqueId) {
    uniqueId = getUserData("userId");
  }
  closeTabsFromButton(tabsData, uniqueId, () => {
    updateTableData(tabIds);
    $(".tabs-count").text(numberFormatter(tabsData.length));
  });
}

function initTabOpen(pageLink, e) {
  e.preventDefault();
  var linkElement = $(pageLink).find(".link");
  var tabId = linkElement.attr("data-tab-id");
  openTabOrUrl(!tabId.match(/.*[a-zA-Z]+.*/) ? parseInt(tabId) : 0, linkElement.attr("href"));
}
