import {
  API_VERSION,
  API_URL,
  VALIDATION_MESSAGES,
  HEADERS,
  SYSTEM_GENERATED_CATEGORIES,
  MESSAGES,
  DOWNLOAD_LINKS,
  ACHIEVEMENT_TYPES
} from "./config.js";
import {
  addAnalysisStatusMessage,
  getGroupsData,
  getOnlyValidTabs,
  getUserData,
  setUserData,
  showNamingDialog,
  showRegisterMessage,
  getLastDate
} from "./panel.js";
import {
  isMobile,
  getBrowser,
  isWebVersion,
  singleElementTransition,
  numberFormatter,
  formatMinutes,
  addPopupMessage
} from "./common.js";
import { InstructionsModal } from "./instructions-modal.js";
import { TourMessageManager } from "./tour.js";

var uniqueId = undefined;
var groups = [];
var userData = {};
window.breakdownInterval = undefined;
var isBreakdownInit = false;
var breakdownInProgress = [];
var newAddedClusters = [];

var callback = function() {
  fetch(API_URL + "/status/" + uniqueId + `?api_version=${API_VERSION}`, { method: "GET" })
    .then(response => response.json())
    .then(data => getGroupsData(data))
    .then(data => {
      if (typeof data == "object") {
        var sortBy = userData["groupsSortField"] ? userData["groupsSortField"] : "tabsCount";
        groups = data.sort((group1, group2) => {
          if (sortBy == "tabsCount") {
            if (group2.name == "Other") {
              return -1;
            }
            if (group1.name == "Other") {
              return 1;
            }
            return group2.tabs.length - group1.tabs.length;
          } else if (sortBy == "readTime") {
            return group2[sortBy] - group1[sortBy];
          } else if (sortBy == "name") {
            return group2[sortBy].toLowerCase() < group1[sortBy].toLowerCase() ? 1 : -1;
          }
        });
        groups.forEach((group, index) => {
          var isSystemGenerated = Object.values(SYSTEM_GENERATED_CATEGORIES).indexOf(group["name"]);
          if (isSystemGenerated !== -1) {
            groups.splice(index, 1)[0];
            groups.push(group);
          }
          if (newAddedClusters.includes(group["id"])) {
            groups.splice(index, 1)[0];
            groups.unshift(group);
          }
        });
      } else {
        groups = [];
      }
      initPage();
    })
    .catch(() => {
      new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
    });
};

export function initTopicsPage() {
  userData = getUserData();
  uniqueId = userData["userId"];
  isBreakdownInit = true;
  checkBreakdownStatus();
  callback();
  if (!isWebVersion()) {
    showNamingDialog();
  }
}

function initPage() {
  initGroups();
  initSystemGroups();
  initAchievements();
  if (newAddedClusters.length) {
    updateBreakdownStatus();
  }
  singleElementTransition(".openai-message", false);
  $(".grid-columns").css("opacity", "0");
  setTimeout(() => {
    $(".grid-columns, .system-grid-columns").masonry({
      itemSelector: ".grid-element",
      gutter: 40,
      horizontalOrder: true,
      columnWidth: ".grid-element"
    });
    $(".grid-columns").masonry("layout");
    $(".grid-columns, .grid-element").css("opacity", "1");
  }, 450);
  if (!groups || !groups.length) {
    $("#subheader").remove();
  }
  if (getBrowser() == "chrome" && !isWebVersion() && !isMobile() && groups.length) {
    $("#group-in-bar").on("click", function() {
      new CustomModal(
        `This will create new groups in Chrome's tab bar corresponding to the tab groups in TabCrunch.
        Tabs that are already grouped will also be affected. Are you sure you want to continue?
        <img id="tabs-group-image" src="images/instructions/tab-bar.png">`,
        "",
        `<button id="cancel-grouping" class="border-btn">Cancel</button>
        <button id="accept-grouping" class="gradient-btn">Group tabs</button>`
      );
      $("#accept-grouping").on("click", function() {
        initChromeGrouping();
        CustomModal.closeModal(this);
      });
      $("#cancel-grouping").on("click", function() {
        CustomModal.closeModal(this);
      });
    });
  } else {
    $("#group-in-bar").remove();
  }
  setSubheaderStats();
  $(".page-title").removeClass("transparent");
  if (userData["lastAnalysisDate"] && groups && groups.length) {
    var date = getLastDate([], true, userData["lastAnalysisDate"]);
    $("#achievements-last-refresh span").text(date.formatted);
    singleElementTransition("#achievements-last-refresh", true);
    singleElementTransition("#achievements", true);
  }
  setTimeout(() => {
    singleElementTransition("#subheader", true);
  }, 250);
  $("main").tooltip();
  if (window.location.href.includes("id=")) {
    var groupId = window.location.href.split("id=")[1].split("&")[0];
    var groupElement = document.getElementById("group-" + groupId);
    if (groupElement) {
      setTimeout(() => {
        document.getElementById("group-" + groupId).scrollIntoView({ behavior: "smooth" });
      }, 150);
    }
  }
  initCloseGroupButtons();
  TourMessageManager.initByPage();
  if (userData["userId"].includes("temp") && tempUserCluster) {
    $(".grid-element").each(function() {
      if ($(this).attr("id") !== `group-${tempUserCluster}`) {
        $(this).addClass("temp-user");
        $(this)
          .find("button")
          .removeClass("close-btn")
          .removeAttr("data-title")
          .addClass("lock-btn icon-background-btn");
      }
    });
  }
}

function setSubheaderStats() {
  if (groups.length) {
    const { totalTabs, totalReadtime, langs } = groups.reduce(
      (acc, group) => {
        group.tabs.forEach(tab => {
          acc.totalTabs++;
          acc.totalReadtime += tab.readTime;
          if (tab.language) {
            acc.langs.add(tab.language);
          }
        });
        return acc;
      },
      { totalTabs: 0, totalReadtime: 0, langs: new Set() }
    );

    $("#tabs-stats").addClass("transparent");
    setTimeout(() => {
      $("#tabs-stats").text(
        `${groups.length} ${groups.length > 1 ? "groups" : "group"}, ${totalTabs} ${totalTabs > 1 ? "tabs" : "tab"}, ${
          langs.size
        }  ${langs.size > 1 ? "languages" : "language"}, ${formatMinutes(totalReadtime, false)} reading time`
      );
      $("#tabs-stats").removeClass("transparent");
    }, 300);
  }
  $("main").tooltip();
}

function initCloseGroupButtons() {
  $("#close-groups").on("click", function() {
    closeTabs(groups);
  });

  $(".grid-element").on("click", function(e) {
    if ($(this).hasClass("temp-user")) {
      showRegisterMessage();
      return;
    }
    if ($(e.target).hasClass("close-btn")) {
      var groupId = parseInt($(this).attr("data-group"));
      var groupData = groups.filter(groupData => groupData.id == groupId);
      closeTabs(groupData[0].tabs, $(this));
    } else {
      navigateToPage($(this).attr("data-href"));
      var tourStep = getUserData("tourStep");
      if (getUserData("takingTour") == "1" && tourStep && tourStep == "groups") {
        TourMessageManager.updateStep("editTitle");
      }
    }
  });
}

export function closeTabs(tabsData, groupElement = null) {
  if (tabsData.length && tabsData[0].tabs) {
    tabsData = tabsData.reduce((acc, groupData) => {
      if (!groupElement && groupData.name == SYSTEM_GENERATED_CATEGORIES.missingPage) {
        return acc;
      }
      acc.push(...groupData.tabs);
      return acc;
    }, []);
  } else {
    tabsData = tabsData.reduce((acc, tabData) => {
      if (tabData.cluster_name == SYSTEM_GENERATED_CATEGORIES.missingPage) {
        return acc;
      }
      acc.push(tabData);
      return acc;
    }, []);
  }
  var tabsToRemove = tabsData.map(tab => tab.tabId);
  var tabsObject = getBrowser(true, true);
  if (isWebVersion() || !tabsObject || !tabsObject.remove) {
    confirmGroupClose(groupElement, tabsToRemove);
  } else {
    var urlsToRemove = tabsData.map(tab => tab.url);
    tabsObject
      .query({})
      .then(openedTabs => {
        var idsToClose = openedTabs
          .filter(tab => !tab.pinned && urlsToRemove.indexOf(tab.url) != -1)
          .map(tab => tab.id);
        confirmGroupClose(groupElement, tabsToRemove, idsToClose);
      })
      .catch(error => {
        console.error(error);
        confirmGroupClose(groupElement, tabsToRemove);
      });
  }
}

function confirmGroupClose(groupElement = null, tabsToRemove = null, idsToClose = []) {
  var tabsObject = getBrowser(true, true);
  var messageText = "";
  var acceptButtonText = "";

  if (groupElement) {
    messageText =
      isWebVersion() || !tabsObject || !tabsObject.remove
        ? "This will close this entire group in your TabCrunch dashboard, including all tabs belonging to this group. Are you sure you wish to proceed?"
        : "This will close the entire group and all tabs belonging to this group from TabCrunch and your browser. Are you sure you wish to proceed?";
    acceptButtonText = "Yes, close the group";
  } else {
    if (isWebVersion()) {
      initManualCloseMessage();
      return;
    }
    messageText = `<p>This will close all analysed tabs in your browser to save memory and reduce load on your device. All tabs are safely stored in TabCrunch under Tab Groups so you can open them again in your browser at any time.</p>
      <p>Any unanalysed tabs will remain open in your browser. This would include tabs which you have specifically excluded from the analysis as well as tabs which we were unable to analyse due to missing pages or content. These tabs can also be found in the “Unanalysed tabs” group under Tab groups.</p>`;
    acceptButtonText = "Clear browser";
  }

  CustomModal.closeModal();
  CustomModal.closeModal("#tour-text-container");

  var modalParams = {};
  modalParams["closeCallback"] = function() {
    var currentStep = window.location.pathname == "/analyse.html" ? "seeAnalysis" : "closeTabsFromGroups";
    TourMessageManager.initByStep(["closeTabs", "closeTabsFromGroups", "seeAnalysis"], currentStep);
  };

  new CustomModal(
    messageText,
    "",
    `<button class="cancel-btn border-btn">Cancel</button>
    <button id="close-group" class="gradient-btn">${acceptButtonText}</button>`,
    modalParams
  );

  $("#close-group").on("click", function() {
    if (groupElement) {
      if (!uniqueId) {
        userData = getUserData();
        var uniqueId = userData["userId"];
      }
      fetch(API_URL + "/delete_tab/" + uniqueId + `?api_version=${API_VERSION}`, {
        method: "POST",
        headers: HEADERS,
        body: JSON.stringify({ ids: tabsToRemove })
      })
        .then(response => {
          if (response.status >= 500) {
            throw new Error(VALIDATION_MESSAGES.serverError);
          }
          if (response.ok) {
            var page = window.location.href;
            if (page.indexOf("topics.html") != -1) {
              closeTabsAndUpdatePage();
              var groupId = parseInt(groupElement.attr("data-group"));
              groups = groups.filter(groupData => groupData.id != groupId);
              setSubheaderStats();
            } else if (groupElement.attr("id") == "close-tabs-btn") {
              closeTabsAndUpdatePage();
              navigateToPage("topics.html");
            } else if (page.indexOf("topic.html") != -1) {
              navigateToPage("topics.html");
            }
          }
        })
        .catch(error => {
          console.log(error);
          new CustomModal(VALIDATION_MESSAGES.serverError);
        });
    } else {
      CustomModal.closeModal();
      try {
        tabsObject.remove(idsToClose);
        addPopupMessage("tabClose", { tabsCount: 2 });
        modalParams["closeCallback"]();
      } catch (error) {
        console.error(error);
        setTimeout(() => {
          new CustomModal(VALIDATION_MESSAGES.closeGroupError);
        }, 400);
      }
    }
    CustomModal.closeModal(this);
  });

  $(".cancel-btn").on("click", function() {
    CustomModal.closeModal($(this));
    modalParams["closeCallback"]();
  });

  function closeTabsAndUpdatePage() {
    if (idsToClose && idsToClose.length) {
      try {
        tabsObject.remove(idsToClose);
        addPopupMessage("groupClose");
      } catch (error) {
        console.error(error);
        new CustomModal(VALIDATION_MESSAGES.closeGroupError);
      }
    } else {
      addPopupMessage("groupClose");
    }
    if ($("#grid-holder .grid-element").length <= 1) {
      singleElementTransition("#grid-holder", false);
      singleElementTransition("#subheader", false);
      setTimeout(() => {
        $("#grid-holder").empty();
        addAnalysisStatusMessage("");
        singleElementTransition("#grid-holder", true);
      }, 300);
    }
    groupElement.remove();
    setTimeout(() => {
      $(".grid-columns").masonry("layout");
    }, 250);
  }
}

function initManualCloseMessage() {
  var browser = getBrowser(false, false, true);
  var isMobileDevice = isMobile();
  var extenstionLink = DOWNLOAD_LINKS[browser];
  var messageText = `<p>Through the browser extension you can automatically close all analysed tabs and use other features which are not accessible from the website.</p>
    <a id="install-link" href="${extenstionLink}">
      <button class="gradient-btn" type="button">Install extension</button>
    </a>
    <p>Don't want to download the extension?<br>You can still close your tabs manually. Just bear in mind that this will close any unanalysed tabs as well, but you can easily open them again from your Tab Groups by searching for the Unanalysed tabs group.</p>`;
  if (isMobileDevice) {
    messageText += `<p>Not sure how to close all tabs in your mobile browser?</p>
      <button id="close-instuctions-btn" class="gradient-btn" type="button">See instructions</button>`;
  }

  new CustomModal(messageText, "It looks like you are not using the browser extension.");

  if (isMobileDevice) {
    $("#close-instuctions-btn").on("click", function() {
      CustomModal.closeModal();
      new InstructionsModal("close");
    });
  }
}

async function initChromeGrouping() {
  var tabsObject = getBrowser(true, false);
  if (!tabsObject || !groups) {
    return;
  }
  var currentTabs = await tabsObject.tabs.query({});
  currentTabs = getOnlyValidTabs(currentTabs);
  var currentTabsUrls = currentTabs.map(tab => {
    return tab.url;
  });
  tabsObject.permissions.request(
    {
      permissions: ["tabGroups"]
    },
    async function(granted) {
      if (granted) {
        for (var group of groups) {
          if (!group["tabs"].length) {
            continue;
          }
          var tabIds = group["tabs"]
            .filter(tab => {
              var tabIndexInBrowser = currentTabsUrls.indexOf(tab.url);
              if (tabIndexInBrowser > -1) {
                tab.id = currentTabs[tabIndexInBrowser].id;
                return true;
              }
              return false;
            })
            .map(tab => {
              return tab.id;
            });
          if (tabIds.length) {
            var existingGroup = await chrome.tabGroups.query({ title: group.name });
            if (existingGroup && existingGroup.length) {
              await tabsObject.tabs.group({
                tabIds: tabIds,
                groupId: existingGroup[0].id
              });
            } else {
              var groupId = await tabsObject.tabs.group({
                tabIds: tabIds
              });
              await tabsObject.tabGroups.update(groupId, {
                title: group.name
              });
            }
          }
        }
      } else {
        new CustomModal(VALIDATION_MESSAGES.tabBarGroupPermissionDenied, "", "");
      }
    }
  );
}

function initGroups() {
  if ((!groups || !groups.length) && !$("#no-data-container").length) {
    return;
  }
  var groupsData = groups.filter(
    group => ![SYSTEM_GENERATED_CATEGORIES.missingPage, SYSTEM_GENERATED_CATEGORIES.other].includes(group["name"])
  );
  populateGroups("all", groupsData, ".grid-columns");
  addMissingBreakdownGroup();
}

function initSystemGroups() {
  var systemGroups = groups.filter(group =>
    [SYSTEM_GENERATED_CATEGORIES.missingPage, SYSTEM_GENERATED_CATEGORIES.other].includes(group["name"])
  );
  if (systemGroups.length) {
    populateGroups("system", systemGroups, ".system-grid-columns");
    singleElementTransition(".system-grid-columns", true);
  }
}

function addMissingBreakdownGroup() {
  var groupNames = groups.map(group => group["name"]);
  userData = getUserData();
  var breakdownNames = !userData["breakdownNames"] ? [] : JSON.parse(userData["breakdownNames"]);
  if (breakdownNames) {
    var missingNames = breakdownNames.filter(name => !groupNames.includes(name));
    populateGroups("breakdown", missingNames, ".grid-columns");
  }
}

function populateGroups(type, groups, container) {
  var breakdownNames = !userData["breakdownNames"] ? [] : JSON.parse(userData["breakdownNames"]);
  var allGroupsContainer = $(container);
  var groupTemplate = $("#group-template")[0].content;
  for (var groupData of groups) {
    var isBreakdownGroup = type === "breakdown" || (type === "all" && breakdownNames.includes(groupData["name"]));
    var group = $(groupTemplate)
      .find(".grid-element")
      .clone();
    var title = type === "breakdown" ? groupData : groupData.name;
    var summary = isBreakdownGroup
      ? MESSAGES.breakdownGroup
      : groupData.name != "Other"
      ? groupData.summary
      : "Tabs that are not related to any of the existing groups.";
    var tabsCount = isBreakdownGroup ? "..." : numberFormatter(groupData.tabs.length);
    var readingTimeRaw = isBreakdownGroup ? "..." : groupData.tabs.reduce((acc, tab) => acc + (tab.readTime || 0), 0);
    var readingTime = isBreakdownGroup ? "..." : formatMinutes(readingTimeRaw);
    var languages = isBreakdownGroup
      ? "..."
      : Object.entries(
          groupData.tabs.reduce(
            (acc, tab) => (tab.language ? { ...acc, [tab.language]: (acc[tab.language] || 0) + 1 } : acc),
            {}
          )
        )
          .sort((a, b) => b[1] - a[1])
          .map(([language]) => language)
          .join(", ")
          .toUpperCase();
    group.find(".element-header .title").text(title);
    group.find(".summary-container .summary").text(summary);
    group.find(".tabs-count").text(tabsCount);
    group.find(".reading-time").text(readingTimeRaw ? readingTime : "N/A");
    group.find(".languages").text(languages ? languages : "N/A");
    if (isBreakdownGroup) {
      group.find(".group-color").addClass("breakdown-color");
      group.addClass("no-click");
    } else {
      group.attr("id", "group-" + groupData.id);
      group.attr("data-group", groupData.id);
      group.attr("data-href", `topic.html?id=${groupData.id}`);
      group.find(".group-color").css("background", groupData.color);
      if (newAddedClusters.includes(groupData.id)) {
        group.addClass("new-cluster");
      }
    }
    allGroupsContainer.append(group);
  }
}

function checkBreakdownStatus() {
  breakdownInterval = setInterval(() => {
    updateBreakdownStatus(breakdownInterval);
  }, 10000);
  if (isBreakdownInit) {
    updateBreakdownStatus(breakdownInterval);
  }
}

async function updateBreakdownStatus(breakdownInterval) {
  userData = getUserData();
  var currentBreakdownNames = !userData["breakdownNames"] ? [] : JSON.parse(userData["breakdownNames"]);
  if (uniqueId && !uniqueId.includes("temp")) {
    var response = await fetch(API_URL + "/breakdown/" + uniqueId + `?api_version=${API_VERSION}`, {
      method: "POST",
      headers: HEADERS,
      body: JSON.stringify({ groupIDs: newAddedClusters })
    });
    response = await response.json();
    newAddedClusters = response.added;
    if ((response.breakdown.length === 0 && newAddedClusters.length === 0) || newAddedClusters.length) {
      isBreakdownInit = false;
      clearInterval(breakdownInterval);
      if (breakdownInProgress.length > 0) {
        breakdownInProgress = [];
        setUserData({
          breakdownNames: ""
        });
        window.location.reload();
      }
    } else {
      response.breakdown.map(function(element) {
        if (!breakdownInProgress.includes(element)) {
          breakdownInProgress.push(element);
        }
        for (var group of groups) {
          if (group["id"] == element && !currentBreakdownNames.includes(group["name"])) {
            currentBreakdownNames.push(group["name"]);
            setUserData({
              breakdownNames: JSON.stringify(currentBreakdownNames)
            });
          }
        }
      });
    }
  }
}

function initAchievements() {
  fetch(API_URL + "/achievements/" + uniqueId + `?api_version=${API_VERSION}`, {
    method: "GET"
  })
    .then(function(response) {
      if (response.ok) {
        response.json().then(function(data) {
          var allAchievementsContainer = $("#achievements");
          var achievementTemplate = $("#achievement-template")[0].content;
          var achievements = data["achievements"];
          for (var achievement in achievements) {
            var achievementData = achievements[achievement];
            var achievementGroup = $(achievementTemplate)
              .find(".achievements-group")
              .clone();
            achievementGroup.attr("id", "achievement-" + achievement);
            achievementGroup.find(".group-info").html(`${achievementData["value"]}% ${ACHIEVEMENT_TYPES[achievement]}`);
            allAchievementsContainer.append(achievementGroup);
            var position = parseInt(
              (achievementGroup.find(".waves").height() * parseInt(achievementData["value"])) / 100
            );
            var waveHeight = position > 30 ? 60 - position - 37 : 30 - position;
            achievementGroup.find(".wave-back").css({ transform: `translateY(${waveHeight}px) scale(0.31, 0.18)` });
            achievementGroup.find(".wave-front").css({ transform: `translateY(${waveHeight}px) scale(0.31, 0.18)` });
          }
        });
      }
    })
    .catch(() => {
      addPopupMessage("achievementsError");
    });
}
