import { API_VERSION, API_URL, HEADERS, VALIDATION_MESSAGES } from "./config.js";
import { getUserData, setUserData } from "./panel.js";
import { singleElementTransition, startPreloader, preloader } from "./common.js";

export function initIndexPage() {
  var urlParams = new URLSearchParams(window.location.search);
  var userId = urlParams.get("id");
  var userData = getUserData();
  var localUserId = userData["userId"] ? userData["userId"] : undefined;

  if (userId) {
    if (!localUserId || localUserId != userId || !userData["nickname"]) {
      preloader(true, "main");
      setTimeout(() => {
        fetch(API_URL + "/qr_code/" + userId + `?api_version=${API_VERSION}`, {
          method: "GET",
          headers: HEADERS
        })
          .then(response => {
            preloader(false, "main");
            if (!response || response.status >= 500) {
              throw new Error(VALIDATION_MESSAGES.serverError);
            } else {
              singleElementTransition("#verification-form", true);
              initVerificationForm(userId);
            }
          })
          .catch(() => {
            new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
          });
      }, 2000);
    } else {
      fetch(API_URL + "/users/" + userId + `?api_version=${API_VERSION}`, {
        method: "GET",
        headers: HEADERS
      })
        .then(response => {
          response.json().then(data => {
            if (data["active"] === 2) {
              setUserData({ userId: userId, nickname: data["nickname"], registered: true });
              window.location.href = "topics.html";
            }
          });
        })
        .catch(() => {
          new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
        });
    }
  } else {
    singleElementTransition("#feature-container", true);
  }
}

function initVerificationForm(userId) {
  $("#verification-form").on("submit", function(e) {
    e.preventDefault();
    startPreloader("#verification-form", "main");
    singleElementTransition("#account-nav", false);
    setTimeout(() => {
      fetch(API_URL + "/qr_validation/" + userId + `?api_version=${API_VERSION}`, {
        method: "POST",
        headers: HEADERS,
        body: JSON.stringify({ code: $("#code").val() })
      })
        .then(response => {
          preloader(false, "main");
          if (!response || response.status >= 500) {
            throw new Error(VALIDATION_MESSAGES.serverError);
          }
          if (response.status == 404) {
            $("#verification-form .invalid").removeClass("invisible");
            singleElementTransition("#verification-form", true);
            singleElementTransition("#account-nav", true);
          } else {
            response.json().then(data => {
              setUserData({ userId: userId, nickname: data["nickname"] });
              $("#account-nav .login, #account-nav .sign-up").remove();
              singleElementTransition("#main-menu-container", true);
              singleElementTransition("#open-mobile-menu-btn", true);
              window.location.href = "topics.html";
            });
          }
        })
        .catch(() => {
          preloader(false, "main");
          singleElementTransition("#verification-form", true);
          singleElementTransition("#account-nav", true);
          new CustomModal(VALIDATION_MESSAGES.serverError, "", "");
        });
    }, 2000);
  });
}
